/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.tests;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.evoco.webdriver.WebDriverBuilder;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.results.ResultsManager;

public abstract class BaseAbstractTest {
    private static final Logger logger = LoggerFactory.getLogger(BaseAbstractTest.class);
    private String testId;
    protected EventFiringWebDriver webDriver;
    protected static ResultsManager resultsManager;

    @BeforeAll
    public static void beforeAll() {
        resultsManager = new ResultsManager();
        resultsManager.createScreenshotDirectory();
        TestConfigHelper.get().printToleratedExceptions();
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.testId = this.generateTestId();
        this.webDriver = new WebDriverBuilder().setResultsDirectory(resultsManager.getScreenshotDirectory()).build();
        this.webDriver.get(TestConfigHelper.get().getBaseUrl());
        this.webDriver.manage().window().maximize();
    }

    @AfterEach
    public void tearDown() {
        logger.debug("Test correlation ID: {}", (Object)this.testId);
        this.webDriver.quit();
    }

    public String getTestId() {
        return this.testId;
    }

    private String generateTestId() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        String testId = StringUtils.replace((String)BaseEncoding.base64Url().encode(bb.array()), (String)"=", (String)"").toUpperCase();
        logger.debug("Test Correlation ID is: {}", (Object)testId);
        return testId;
    }
}

