/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.configuration.driver;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import uk.co.evoco.webdriver.configuration.BrowserType;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredDriver;

public class ConfiguredFirefoxDriver
implements ConfiguredDriver {
    @Override
    public WebDriver getRemoteDriver() throws IOException {
        return new RemoteWebDriver(TestConfigHelper.get().getGridConfig().getGridUrl(), (Capabilities)this.getOptions());
    }

    @Override
    public WebDriver getLocalDriver() throws IOException {
        this.createLogDirectory();
        System.setProperty("webdriver.firefox.logfile", "logs/firefox-driver.logs");
        WebDriverManager.firefoxdriver().setup();
        return new FirefoxDriver(this.getOptions());
    }

    public FirefoxOptions getOptions() throws IOException {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        Iterator firefoxPreferences = TestConfigHelper.get().getBrowserPreferences(BrowserType.FIREFOX).fields();
        block4: while (firefoxPreferences.hasNext()) {
            Map.Entry entry = (Map.Entry)firefoxPreferences.next();
            JsonNode value = (JsonNode)entry.getValue();
            String key = (String)entry.getKey();
            switch (value.getNodeType()) {
                case BOOLEAN: {
                    firefoxOptions.addPreference(key, value.asBoolean());
                    continue block4;
                }
                case NUMBER: {
                    firefoxOptions.addPreference(key, value.asInt());
                    continue block4;
                }
            }
            if (key.equals("browser.download.dir")) {
                firefoxOptions.addPreference(key, this.createFileDownloadDirectory(value.asText()));
                continue;
            }
            firefoxOptions.addPreference(key, value.asText());
        }
        firefoxOptions.setHeadless(TestConfigHelper.get().isHeadless());
        return firefoxOptions;
    }
}

