/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.configuration.driver;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import uk.co.evoco.webdriver.configuration.BrowserType;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredDriver;

public class ConfiguredChromeDriver
implements ConfiguredDriver {
    @Override
    public WebDriver getRemoteDriver() throws IOException {
        return new RemoteWebDriver(TestConfigHelper.get().getGridConfig().getGridUrl(), (Capabilities)this.getOptions());
    }

    @Override
    public WebDriver getLocalDriver() throws IOException {
        this.createLogDirectory();
        System.setProperty("webdriver.chrome.logfile", "logs/chrome-driver.log");
        WebDriverManager.chromedriver().setup();
        return new ChromeDriver(this.getOptions());
    }

    public ChromeOptions getOptions() throws IOException {
        ChromeOptions chromeOptions = new ChromeOptions();
        HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
        Iterator browserPreferences = TestConfigHelper.get().getBrowserPreferences(BrowserType.CHROME).fields();
        block4: while (browserPreferences.hasNext()) {
            Map.Entry entry = (Map.Entry)browserPreferences.next();
            JsonNode value = (JsonNode)entry.getValue();
            String key = (String)entry.getKey();
            switch (value.getNodeType()) {
                case BOOLEAN: {
                    chromePrefs.put(key, value.asBoolean());
                    continue block4;
                }
                case NUMBER: {
                    chromePrefs.put(key, value.asInt());
                    continue block4;
                }
            }
            if (key.equals("download.default_directory")) {
                chromePrefs.put(key, this.createFileDownloadDirectory(value.asText()));
                continue;
            }
            chromePrefs.put(key, value.asText());
        }
        chromeOptions.setExperimentalOption("prefs", chromePrefs);
        chromeOptions.setHeadless(TestConfigHelper.get().isHeadless());
        return chromeOptions;
    }
}

