/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.saucelabs.saucebindings.Browser;
import com.saucelabs.saucebindings.PageLoadStrategy;
import com.saucelabs.saucebindings.SaucePlatform;
import com.saucelabs.saucebindings.UnhandledPromptBehavior;
import java.net.MalformedURLException;
import java.net.URL;
import uk.co.evoco.exceptions.SauceLabsCredentialsException;
import uk.co.evoco.webdriver.configuration.SauceLabsCredentials;

public class SauceLabsConfig {
    private String seleniumVersion;
    private URL sauceRemoteUrl;
    private boolean acceptInsecureCerts;
    private boolean strictFileInteractability;
    private boolean capturePerformance;
    private boolean recordLogs;
    private boolean recordScreenshots;
    private boolean recordVideo;
    private boolean extendedDebugging;
    private SaucePlatform saucePlatform;
    private Browser browserName;
    private String browserVersion;
    private PageLoadStrategy pageLoadStrategy;
    private UnhandledPromptBehavior unhandledPromptBehavior;

    public String getSeleniumVersion() {
        return this.seleniumVersion;
    }

    @JsonProperty(value="seleniumVersion")
    public void setSeleniumVersion(String seleniumVersion) {
        this.seleniumVersion = seleniumVersion;
    }

    public SauceLabsCredentials getCredentials() throws SauceLabsCredentialsException {
        return new SauceLabsCredentials();
    }

    public URL getSauceRemoteUrl() {
        return this.sauceRemoteUrl;
    }

    @JsonProperty(value="sauceLabsRemoteGridUrl")
    public void setSauceRemoteUrl(String sauceRemoteUrl) throws MalformedURLException, SauceLabsCredentialsException {
        this.sauceRemoteUrl = new URL("https://" + this.getCredentials().getUsername() + ":" + this.getCredentials().getAccessKey() + "@" + sauceRemoteUrl);
    }

    public boolean isAcceptInsecureCerts() {
        return this.acceptInsecureCerts;
    }

    @JsonProperty(value="acceptInsecureCerts")
    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.acceptInsecureCerts = acceptInsecureCerts;
    }

    public boolean isStrictFileInteractability() {
        return this.strictFileInteractability;
    }

    @JsonProperty(value="strictFileInteractability")
    public void setStrictFileInteractability(boolean strictFileInteractability) {
        this.strictFileInteractability = strictFileInteractability;
    }

    public boolean isCapturePerformance() {
        return this.capturePerformance;
    }

    @JsonProperty(value="capturePerformance")
    public void setCapturePerformance(boolean capturePerformance) {
        this.capturePerformance = capturePerformance;
    }

    public boolean isRecordLogs() {
        return this.recordLogs;
    }

    @JsonProperty(value="recordLogs")
    public void setRecordLogs(boolean recordLogs) {
        this.recordLogs = recordLogs;
    }

    public boolean isRecordScreenshots() {
        return this.recordScreenshots;
    }

    @JsonProperty(value="recordScreenshots")
    public void setRecordScreenshots(boolean recordScreenshots) {
        this.recordScreenshots = recordScreenshots;
    }

    public boolean isRecordVideo() {
        return this.recordVideo;
    }

    @JsonProperty(value="recordVideo")
    public void setRecordVideo(boolean recordVideo) {
        this.recordVideo = recordVideo;
    }

    public SaucePlatform getSaucePlatform() {
        return this.saucePlatform;
    }

    @JsonProperty(value="saucePlatform")
    public void setSaucePlatform(String saucePlatform) {
        this.saucePlatform = SaucePlatform.valueOf((String)saucePlatform);
    }

    public Browser getBrowserName() {
        return this.browserName;
    }

    @JsonProperty(value="browserName")
    public void setBrowserName(String browserName) {
        this.browserName = Browser.valueOf((String)browserName);
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    @JsonProperty(value="browserVersion")
    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion.toLowerCase();
    }

    public PageLoadStrategy getPageLoadStrategy() {
        return this.pageLoadStrategy;
    }

    @JsonProperty(value="pageLoadStrategy")
    public void setPageLoadStrategy(String pageLoadStrategy) {
        this.pageLoadStrategy = PageLoadStrategy.valueOf((String)pageLoadStrategy);
    }

    public UnhandledPromptBehavior getUnhandledPromptBehavior() {
        return this.unhandledPromptBehavior;
    }

    @JsonProperty(value="unhandledPromptBehaviour")
    public void setUnhandledPromptBehavior(String unhandledPromptBehavior) {
        this.unhandledPromptBehavior = UnhandledPromptBehavior.valueOf((String)unhandledPromptBehavior);
    }

    public boolean isExtendedDebugging() {
        return this.extendedDebugging;
    }

    @JsonProperty(value="extendedDebugging")
    public void setExtendedDebugging(boolean extendedDebugging) {
        this.extendedDebugging = extendedDebugging;
    }
}

