/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver;

import java.io.File;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;

public class WebDriverListener
extends AbstractWebDriverEventListener {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverListener.class);
    private File screenshotDirectory;

    public void setScreenshotDirectory(File screenshotDirectory) {
        this.screenshotDirectory = screenshotDirectory;
    }

    public void beforeFindBy(By by, WebElement webElement, WebDriver webDriver) {
        new WebDriverWait(webDriver, TestConfigHelper.get().getWebDriverWaitTimeout()).until((Function)ExpectedConditions.presenceOfElementLocated((By)by));
    }

    public void beforeClickOn(WebElement webElement, WebDriver webDriver) {
        new WebDriverWait(webDriver, TestConfigHelper.get().getWebDriverWaitTimeout()).until((Function)ExpectedConditions.elementToBeClickable((WebElement)webElement));
    }

    public void onException(Throwable throwable, WebDriver webDriver) {
        try {
            if (TestConfigHelper.get().isTakeScreenshotOnError()) {
                File scrFile = (File)((TakesScreenshot)webDriver).getScreenshotAs(OutputType.FILE);
                String filename = UUID.randomUUID().toString() + "-FAILED-" + throwable.getClass().getName() + ".jpeg";
                FileUtils.copyFile((File)scrFile, (File)new File(this.screenshotDirectory.getPath() + "/" + filename));
            }
        }
        catch (Exception e) {
            logger.error("Unable to Save to directory: {}", (Object)this.screenshotDirectory.getPath());
        }
    }
}

