/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver;

import com.deque.html.axecore.results.Results;
import com.deque.html.axecore.selenium.AxeBuilder;
import com.deque.html.axecore.selenium.AxeReporter;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.WebDriver;

public class AccessibilityBase {
    private static final String reportPath = System.getProperty("user.dir") + "\\src\\test\\java\\reports\\";

    public static void checkAccessibilityViolations(WebDriver webDriver) throws IOException {
        String reportFile = reportPath + "accessibilityReport";
        AxeBuilder builder = new AxeBuilder();
        Results results = builder.analyze(webDriver);
        AccessibilityBase.saveReport(results, reportFile);
    }

    private static void saveReport(Results results, String reportFile) {
        List violations = results.getViolations();
        if (violations.size() == 0) {
            Assert.assertTrue((String)"No violations found", (boolean)true);
        } else {
            AxeReporter.writeResultsToJsonFile((String)reportFile, (Results)results);
            Assert.assertEquals((long)0L, (long)violations.size());
        }
    }
}

