/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.tests;

import java.io.IOException;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.evoco.webdriver.WebDriverBuilder;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.results.ResultsManager;

public abstract class BaseAbstractTest {
    private static final Logger logger = LoggerFactory.getLogger(BaseAbstractTest.class);
    private String testId;
    protected EventFiringWebDriver webDriver;
    protected static ResultsManager resultsManager;

    @BeforeAll
    public static void beforeAll() {
        resultsManager = new ResultsManager();
        resultsManager.createScreenshotDirectory();
        TestConfigHelper.get().printToleratedExceptions();
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.testId = UUID.randomUUID().toString();
        this.webDriver = new WebDriverBuilder().setResultsDirectory(resultsManager.getScreenshotDirectory()).build();
        this.webDriver.get(TestConfigHelper.get().getBaseUrl());
        this.webDriver.manage().window().maximize();
    }

    @AfterEach
    public void tearDown() {
        logger.debug("Test correlation ID: {}", (Object)this.testId);
        this.webDriver.quit();
    }

    public String getTestId() {
        return this.testId;
    }
}

