/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.metrics;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jmx.JmxReporter;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;

public class MetricRegistryHelper {
    private static final MetricRegistry metricRegistry = new MetricRegistry();
    private static MetricRegistryHelper metricRegistryHelper;
    private JmxReporter jmxReporter;
    private GraphiteReporter graphiteReporter;
    private Graphite graphite;

    private MetricRegistryHelper() {
        if (TestConfigHelper.get().getMetricsConfig().getJmxConfig().isEnabled()) {
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
            this.jmxReporter.start();
        }
        if (TestConfigHelper.get().getMetricsConfig().getGraphiteConfig().isEnabled()) {
            this.graphite = new Graphite(new InetSocketAddress(TestConfigHelper.get().getMetricsConfig().getGraphiteConfig().getHost(), TestConfigHelper.get().getMetricsConfig().getGraphiteConfig().getPort()));
            this.graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith("selenium-pom-framework").convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(this.graphite);
            this.graphiteReporter.start(30L, TimeUnit.SECONDS);
        }
    }

    public static MetricRegistry get() {
        if (null == metricRegistryHelper) {
            metricRegistryHelper = new MetricRegistryHelper();
        }
        return metricRegistry;
    }
}

