/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.evoco.webdriver.utils.TolerantInteraction;

public class TolerantExceptionHandler {
    private List<String> tolerantExceptions;
    private Logger logger = LoggerFactory.getLogger(TolerantInteraction.class);

    public TolerantExceptionHandler(List<String> tolerantExceptions) {
        this.tolerantExceptions = tolerantExceptions;
    }

    public TolerantExceptionHandler(List<String> tolerantExceptions, Logger logger) {
        this(tolerantExceptions);
        this.logger = logger;
    }

    public Throwable propagateIfNotIgnored(Throwable throwable) throws Throwable {
        for (String tolerantExceptionClassName : this.tolerantExceptions) {
            if (!this.isInstanceOf(tolerantExceptionClassName, throwable)) continue;
            this.logger.info("Exception {} will be ignored", (Object)tolerantExceptionClassName);
            return throwable;
        }
        throw throwable;
    }

    private boolean isInstanceOf(String source, Throwable target) {
        try {
            return Class.forName(source).isInstance(target);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

