/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class JsonUtils {
    private JsonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> T fromString(String jsonString, TypeReference<T> type) throws JsonProcessingException {
        return (T)new ObjectMapper().readValue(jsonString, type);
    }

    public static <T> T fromString(String jsonString, Class<T> type) throws JsonProcessingException {
        return (T)new ObjectMapper().readValue(jsonString, type);
    }

    public static <T> T fromFile(File file, Class<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(file, type);
    }

    public static <T> T fromFile(File file, TypeReference<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(file, type);
    }

    public static <T> T fromFile(InputStream jsonStream, Class<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(jsonStream, type);
    }

    public static <T> T fromFile(String filePath, Class<T> type) throws IOException {
        return (T)new ObjectMapper().readValue(new File(filePath), type);
    }

    public static String toString(Object object) throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString(object);
    }
}

