/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver.utils;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import uk.co.evoco.metrics.MetricRegistryHelper;

public final class JavaScriptUtils {
    private static final Timer executeStringAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"JavaScriptUtils.executeString", (String[])new String[0]));
    private static final Timer executeFileAction = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"JavaScriptUtils.executeFile", (String[])new String[0]));

    private JavaScriptUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void executeString(WebDriver webDriver, String javascript) {
        try (Timer.Context ignored = executeStringAction.time();){
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)webDriver;
            javascriptExecutor.executeScript(javascript, new Object[0]);
        }
    }

    public static void executeString(WebDriver webDriver, WebElement webElement, String javascript) {
        try (Timer.Context ignored = executeStringAction.time();){
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)webDriver;
            javascriptExecutor.executeScript(javascript, new Object[]{webElement});
        }
    }

    public static void executeFile(WebDriver webDriver, String filename) throws IOException {
        try (Timer.Context ignored = executeFileAction.time();){
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)webDriver;
            String javascript = FileUtils.readFileToString((File)new File(ClassLoader.getSystemResource(filename).getFile()), (Charset)Charset.forName("UTF-8"));
            javascriptExecutor.executeScript(javascript, new Object[0]);
        }
    }
}

