/*
 * Decompiled with CFR 0.152.
 */
package uk.co.evoco.webdriver;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import uk.co.evoco.metrics.MetricRegistryHelper;
import uk.co.evoco.webdriver.configuration.TestConfigHelper;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredChromeDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredEdgeDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredFirefoxDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredInternetExplorerDriver;
import uk.co.evoco.webdriver.configuration.driver.ConfiguredSafariDriver;

public class WebDriverBuilder {
    private File screenshotDirectory;
    private static final Timer webDriverBuild = MetricRegistryHelper.get().timer(MetricRegistry.name((String)"WebDriverBuilder.build", (String[])new String[0]));

    public WebDriverBuilder setResultsDirectory(File screenshotDirectory) {
        this.screenshotDirectory = screenshotDirectory;
        return this;
    }

    public EventFiringWebDriver build() throws IOException {
        try (Timer.Context ignored = webDriverBuild.time();){
            switch (TestConfigHelper.get().getBrowserType()) {
                case CHROME: {
                    EventFiringWebDriver eventFiringWebDriver = new ConfiguredChromeDriver().getDriver(this.screenshotDirectory);
                    return eventFiringWebDriver;
                }
                case FIREFOX: {
                    EventFiringWebDriver eventFiringWebDriver = new ConfiguredFirefoxDriver().getDriver(this.screenshotDirectory);
                    return eventFiringWebDriver;
                }
                case IE: {
                    EventFiringWebDriver eventFiringWebDriver = new ConfiguredInternetExplorerDriver().getDriver(this.screenshotDirectory);
                    return eventFiringWebDriver;
                }
                case EDGE: {
                    EventFiringWebDriver eventFiringWebDriver = new ConfiguredEdgeDriver().getDriver(this.screenshotDirectory);
                    return eventFiringWebDriver;
                }
                case SAFARI: {
                    EventFiringWebDriver eventFiringWebDriver = new ConfiguredSafariDriver().getDriver(this.screenshotDirectory);
                    return eventFiringWebDriver;
                }
            }
            throw new RuntimeException("WebDriverBuilder has no valid target browser set in WebDriverConfig");
        }
    }
}

