/*
 * Decompiled with CFR 0.152.
 */
package uk.co.codezen.maven.redlinerpm.rpm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.redline_rpm.Builder;
import org.redline_rpm.IntString;
import org.redline_rpm.header.Architecture;
import org.redline_rpm.header.Os;
import org.redline_rpm.header.RpmType;
import uk.co.codezen.maven.redlinerpm.mojo.RpmMojo;
import uk.co.codezen.maven.redlinerpm.rpm.RpmLink;
import uk.co.codezen.maven.redlinerpm.rpm.RpmPackageAssociation;
import uk.co.codezen.maven.redlinerpm.rpm.RpmPackageRule;
import uk.co.codezen.maven.redlinerpm.rpm.RpmScriptTemplateRenderer;
import uk.co.codezen.maven.redlinerpm.rpm.RpmTrigger;
import uk.co.codezen.maven.redlinerpm.rpm.exception.AbstractRpmException;
import uk.co.codezen.maven.redlinerpm.rpm.exception.SigningKeyFileNotFoundException;
import uk.co.codezen.maven.redlinerpm.rpm.exception.UnknownArchitectureException;
import uk.co.codezen.maven.redlinerpm.rpm.exception.UnknownOperatingSystemException;

public final class RpmPackage {
    private RpmMojo mojo = null;
    private String name = null;
    private String version = null;
    private String projectVersion = null;
    private String release = null;
    private String finalName = null;
    private String url = null;
    private String group = null;
    private String license = null;
    private String summary = null;
    private String description = null;
    private String distribution = null;
    private Architecture architecture = null;
    private Os operatingSystem = null;
    private String buildHostName = null;
    private String packager = null;
    private String sourceRpm = null;
    private boolean attach = true;
    private String classifier = null;
    private File preTransactionScriptFile = null;
    private String preTransactionProgram = null;
    private File preInstallScriptFile = null;
    private String preInstallProgram = null;
    private File postInstallScriptFile = null;
    private String postInstallProgram = null;
    private File preUninstallScriptFile = null;
    private String preUninstallProgram = null;
    private File postUninstallScriptFile = null;
    private String postUninstallProgram = null;
    private File postTransactionScriptFile = null;
    private String postTransactionProgram = null;
    private List<RpmTrigger> triggers = new ArrayList<RpmTrigger>();
    private String signingKey = null;
    private String signingKeyId = null;
    private String signingKeyPassPhrase = null;
    private List<String> prefixes = new ArrayList<String>();
    private List<RpmPackageAssociation> dependencies = new ArrayList<RpmPackageAssociation>();
    private List<RpmPackageAssociation> obsoletes = new ArrayList<RpmPackageAssociation>();
    private List<RpmPackageAssociation> conflicts = new ArrayList<RpmPackageAssociation>();
    private List<RpmLink> links = new ArrayList<RpmLink>();
    private List<RpmPackageRule> rules = new ArrayList<RpmPackageRule>();

    public void setMojo(RpmMojo mojo) {
        this.mojo = mojo;
    }

    public RpmMojo getMojo() {
        return this.mojo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (null == this.name) {
            this.name = this.getMojo().getProjectArtifactId();
        }
        return this.name;
    }

    public void setVersion(String version) {
        if (null != version && version.equals("")) {
            version = null;
        }
        this.projectVersion = version;
        this.version = this.sanitiseVersion(version);
    }

    public String getVersion() {
        if (null == this.version) {
            this.version = this.sanitiseVersion(this.getMojo().getProjectVersion());
        }
        return this.version;
    }

    public String getProjectVersion() {
        if (null == this.projectVersion) {
            this.projectVersion = this.getMojo().getProjectVersion();
        }
        return this.projectVersion;
    }

    private String sanitiseVersion(String version) {
        if (null != version && !version.replaceAll("[a-zA-Z0-9\\.]", "").equals("")) {
            version = version.replaceAll("-", ".");
            version = version.replaceAll("[^a-zA-Z0-9\\.]", "");
        }
        return version;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public String getRelease() {
        if (null == this.release) {
            this.release = Long.toString(System.currentTimeMillis() / 1000L);
        }
        return this.release;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public String getFinalName() {
        if (null == this.finalName) {
            this.finalName = String.format("%s-%s-%s.%s.rpm", this.getName(), this.getVersion(), this.getRelease(), this.getArchitecture().toString().toLowerCase());
        }
        return this.finalName;
    }

    public void setDependencies(List<RpmPackageAssociation> dependencies) {
        this.dependencies = dependencies;
    }

    public List<RpmPackageAssociation> getDependencies() {
        return this.dependencies;
    }

    public void setObsoletes(List<RpmPackageAssociation> obsoletes) {
        this.obsoletes = obsoletes;
    }

    public List<RpmPackageAssociation> getObsoletes() {
        return this.obsoletes;
    }

    public void setConflicts(List<RpmPackageAssociation> conflicts) {
        this.conflicts = conflicts;
    }

    public List<RpmPackageAssociation> getConflicts() {
        return this.conflicts;
    }

    public void setLinks(List<RpmLink> links) {
        if (null != links) {
            for (RpmLink link : links) {
                link.setPackage(this);
            }
        }
        this.links = links;
    }

    public List<RpmLink> getLinks() {
        return this.links;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        if (null == this.url) {
            this.url = this.getMojo().getProjectUrl();
        }
        return this.url;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicense() {
        if (null == this.license) {
            this.license = this.getMojo().getCollapsedProjectLicense();
        }
        return this.license;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setArchitecture(String architecture) throws UnknownArchitectureException {
        if (null == architecture || architecture.equals("")) {
            throw new UnknownArchitectureException(architecture);
        }
        architecture = architecture.toUpperCase();
        try {
            this.architecture = Architecture.valueOf((String)architecture);
        }
        catch (IllegalArgumentException ex) {
            throw new UnknownArchitectureException(architecture, ex);
        }
    }

    public Architecture getArchitecture() {
        if (null == this.architecture) {
            this.architecture = Architecture.NOARCH;
        }
        return this.architecture;
    }

    public void setOperatingSystem(String operatingSystem) throws UnknownOperatingSystemException {
        if (null == operatingSystem || operatingSystem.equals("")) {
            throw new UnknownOperatingSystemException(operatingSystem);
        }
        operatingSystem = operatingSystem.toUpperCase();
        try {
            this.operatingSystem = Os.valueOf((String)operatingSystem);
        }
        catch (IllegalArgumentException ex) {
            throw new UnknownOperatingSystemException(operatingSystem, ex);
        }
    }

    public Os getOperatingSystem() {
        if (null == this.operatingSystem) {
            this.operatingSystem = Os.LINUX;
        }
        return this.operatingSystem;
    }

    public void setBuildHostName(String buildHostName) {
        this.buildHostName = buildHostName;
    }

    public String getBuildHostName() throws UnknownHostException {
        if (null == this.buildHostName) {
            this.buildHostName = InetAddress.getLocalHost().getHostName();
        }
        return this.buildHostName;
    }

    public void setPackager(String packager) {
        this.packager = packager;
    }

    public String getPackager() {
        return this.packager;
    }

    public void setSourceRpm(String sourceRpm) {
        this.sourceRpm = sourceRpm;
    }

    public String getSourceRpm() {
        return this.sourceRpm;
    }

    public void setAttach(boolean attach) {
        this.attach = attach;
    }

    public boolean isAttach() {
        return this.attach;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setPreTransactionScriptFile(File preTransactionScriptFile) {
        this.preTransactionScriptFile = preTransactionScriptFile;
    }

    public File getPreTransactionScriptFile() {
        return this.preTransactionScriptFile;
    }

    public void setPreTransactionProgram(String preTransactionProgram) {
        this.preTransactionProgram = preTransactionProgram;
    }

    public String getPreTransactionProgram() {
        return this.preTransactionProgram;
    }

    public void setPreInstallScriptFile(File preInstallScriptFile) {
        this.preInstallScriptFile = preInstallScriptFile;
    }

    public File getPreInstallScriptFile() {
        return this.preInstallScriptFile;
    }

    public void setPreInstallProgram(String preInstallProgram) {
        this.preInstallProgram = preInstallProgram;
    }

    public String getPreInstallProgram() {
        return this.preInstallProgram;
    }

    public void setPostInstallScriptFile(File postInstallScriptFile) {
        this.postInstallScriptFile = postInstallScriptFile;
    }

    public File getPostInstallScriptFile() {
        return this.postInstallScriptFile;
    }

    public void setPostInstallProgram(String postInstallProgram) {
        this.postInstallProgram = postInstallProgram;
    }

    public String getPostInstallProgram() {
        return this.postInstallProgram;
    }

    public void setPreUninstallScriptFile(File preUninstallScriptFile) {
        this.preUninstallScriptFile = preUninstallScriptFile;
    }

    public File getPreUninstallScriptFile() {
        return this.preUninstallScriptFile;
    }

    public void setPreUninstallProgram(String preUninstallProgram) {
        this.preUninstallProgram = preUninstallProgram;
    }

    public String getPreUninstallProgram() {
        return this.preUninstallProgram;
    }

    public void setPostUninstallScriptFile(File postUninstallScriptFile) {
        this.postUninstallScriptFile = postUninstallScriptFile;
    }

    public File getPostUninstallScriptFile() {
        return this.postUninstallScriptFile;
    }

    public void setPostUninstallProgram(String postUninstallProgram) {
        this.postUninstallProgram = postUninstallProgram;
    }

    public String getPostUninstallProgram() {
        return this.postUninstallProgram;
    }

    public void setPostTransactionScriptFile(File postTransactionScriptFile) {
        this.postTransactionScriptFile = postTransactionScriptFile;
    }

    public File getPostTransactionScriptFile() {
        return this.postTransactionScriptFile;
    }

    public void setPostTransactionProgram(String postTransactionProgram) {
        this.postTransactionProgram = postTransactionProgram;
    }

    public String getPostTransactionProgram() {
        return this.postTransactionProgram;
    }

    public void setTriggers(List<RpmTrigger> triggers) {
        this.triggers = triggers;
    }

    public List<RpmTrigger> getTriggers() {
        return this.triggers;
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKeyId(String signingKeyId) {
        this.signingKeyId = signingKeyId;
    }

    public String getSigningKeyId() {
        return this.signingKeyId;
    }

    public void setSigningKeyPassPhrase(String signingKeyPassPhrase) {
        this.signingKeyPassPhrase = signingKeyPassPhrase;
    }

    public String getSigningKeyPassPhrase() {
        return this.signingKeyPassPhrase;
    }

    public void setPrefixes(List<String> prefixes) {
        if (null == prefixes) {
            prefixes = new ArrayList<String>();
        }
        this.prefixes = prefixes;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public void setRules(List<RpmPackageRule> rules) {
        if (null != rules) {
            for (RpmPackageRule rpmPackageRule : rules) {
                rpmPackageRule.setPackage(this);
            }
        }
        this.rules = rules;
    }

    public List<RpmPackageRule> getRules() {
        return this.rules;
    }

    public Log getLog() {
        return this.getMojo().getLog();
    }

    public Set<String> build() throws IOException, NoSuchAlgorithmException, AbstractRpmException {
        Object scriptFile;
        HashSet<String> fileList = new HashSet<String>();
        String buildDirectory = this.getMojo().getBuildDirectory();
        this.getLog().debug((CharSequence)"Creating RPM builder");
        Builder builder = new Builder();
        builder.setType(RpmType.BINARY);
        this.getLog().debug((CharSequence)"Setting package information");
        builder.setPackage((CharSequence)this.getName(), (CharSequence)this.getVersion(), (CharSequence)this.getRelease());
        builder.setPlatform(this.getArchitecture(), this.getOperatingSystem());
        builder.setGroup((CharSequence)this.getGroup());
        builder.setLicense((CharSequence)this.getLicense());
        builder.setSummary((CharSequence)this.getSummary());
        builder.setDescription((CharSequence)this.getDescription());
        builder.setDistribution((CharSequence)this.getDistribution());
        builder.setBuildHost((CharSequence)this.getBuildHostName());
        builder.setPackager((CharSequence)this.getPackager());
        builder.setUrl((CharSequence)this.getUrl());
        builder.setPrefixes(this.getPrefixes().toArray(new String[0]));
        builder.setSourceRpm(this.getSourceRpm());
        for (RpmPackageAssociation dependency : this.getDependencies()) {
            if (null == dependency.getName()) continue;
            if (dependency.isVersionRange()) {
                if (null != dependency.getMinVersion()) {
                    builder.addDependency(dependency.getName(), 12, dependency.getMinVersion());
                }
                if (null == dependency.getMaxVersion()) continue;
                builder.addDependency(dependency.getName(), 2, dependency.getMaxVersion());
                continue;
            }
            if (null != dependency.getVersion()) {
                builder.addDependency(dependency.getName(), 8, dependency.getVersion());
                continue;
            }
            builder.addDependency(dependency.getName(), 0, "");
        }
        for (RpmPackageAssociation obsolete : this.getObsoletes()) {
            if (null == obsolete.getName()) continue;
            if (obsolete.isVersionRange()) {
                if (null != obsolete.getMinVersion()) {
                    builder.addObsoletes(obsolete.getName(), 12, obsolete.getMinVersion());
                }
                if (null == obsolete.getMaxVersion()) continue;
                builder.addObsoletes(obsolete.getName(), 2, obsolete.getMaxVersion());
                continue;
            }
            if (null != obsolete.getVersion()) {
                builder.addObsoletes(obsolete.getName(), 8, obsolete.getVersion());
                continue;
            }
            builder.addObsoletes(obsolete.getName(), 0, "");
        }
        for (RpmPackageAssociation conflict : this.getConflicts()) {
            if (null == conflict.getName()) continue;
            if (conflict.isVersionRange()) {
                if (null != conflict.getMinVersion()) {
                    builder.addConflicts(conflict.getName(), 12, conflict.getMinVersion());
                }
                if (null == conflict.getMaxVersion()) continue;
                builder.addConflicts(conflict.getName(), 2, conflict.getMaxVersion());
                continue;
            }
            if (null != conflict.getVersion()) {
                builder.addConflicts(conflict.getName(), 8, conflict.getVersion());
                continue;
            }
            builder.addConflicts(conflict.getName(), 0, "");
        }
        for (RpmLink link : this.getLinks()) {
            builder.addLink(link.getPath(), link.getTarget(), link.getModeOrDefault(), link.getOwnerOrDefault(), link.getGroupOrDefault());
        }
        this.getLog().debug((CharSequence)"Setting event hook scripts");
        RpmScriptTemplateRenderer scriptTemplateRenderer = this.getMojo().getTemplateRenderer();
        String scriptPath = String.format("%s%s%s-%s", buildDirectory, File.separator, this.getName(), this.getProjectVersion());
        File scriptTemplate = this.getPreTransactionScriptFile();
        if (null != scriptTemplate) {
            scriptFile = new File(String.format("%s-pretrans-hook", scriptPath));
            scriptTemplateRenderer.render(scriptTemplate, (File)scriptFile);
            builder.setPreTransScript((File)scriptFile);
            builder.setPreTransProgram(this.getPreTransactionProgram());
        }
        if (null != (scriptTemplate = this.getPreInstallScriptFile())) {
            scriptFile = new File(String.format("%s-preinstall-hook", scriptPath));
            scriptTemplateRenderer.render(scriptTemplate, (File)scriptFile);
            builder.setPreInstallScript((File)scriptFile);
            builder.setPreInstallProgram(this.getPreInstallProgram());
        }
        if (null != (scriptTemplate = this.getPostInstallScriptFile())) {
            scriptFile = new File(String.format("%s-postinstall-hook", scriptPath));
            scriptTemplateRenderer.render(scriptTemplate, (File)scriptFile);
            builder.setPostInstallScript((File)scriptFile);
            builder.setPostInstallProgram(this.getPostInstallProgram());
        }
        if (null != (scriptTemplate = this.getPreUninstallScriptFile())) {
            scriptFile = new File(String.format("%s-preuninstall-hook", scriptPath));
            scriptTemplateRenderer.render(scriptTemplate, (File)scriptFile);
            builder.setPreUninstallScript((File)scriptFile);
            builder.setPreUninstallProgram(this.getPreUninstallProgram());
        }
        if (null != (scriptTemplate = this.getPostUninstallScriptFile())) {
            scriptFile = new File(String.format("%s-postuninstall-hook", scriptPath));
            scriptTemplateRenderer.render(scriptTemplate, (File)scriptFile);
            builder.setPostUninstallScript((File)scriptFile);
            builder.setPostUninstallProgram(this.getPostUninstallProgram());
        }
        if (null != (scriptTemplate = this.getPostTransactionScriptFile())) {
            scriptFile = new File(String.format("%s-posttrans-hook", scriptPath));
            scriptTemplateRenderer.render(scriptTemplate, (File)scriptFile);
            builder.setPostTransScript((File)scriptFile);
            builder.setPostTransProgram(this.getPostTransactionProgram());
        }
        for (RpmTrigger trigger : this.getTriggers()) {
            File scriptFile2;
            HashMap<String, IntString> depends = new HashMap<String, IntString>();
            for (RpmPackageAssociation dependency : trigger.getDependencies()) {
                int flags = 0;
                String version = "";
                if (null != dependency.getVersion()) {
                    version = dependency.getVersion();
                } else if (null != dependency.getMinVersion()) {
                    flags = 12;
                    version = dependency.getMinVersion();
                } else if (null != dependency.getMaxVersion()) {
                    flags = 2;
                    version = dependency.getMaxVersion();
                }
                depends.put(dependency.getName(), new IntString(flags, version));
            }
            scriptTemplate = trigger.getPreInstallScriptFile();
            if (null != scriptTemplate) {
                scriptFile2 = new File(String.format("%s-preinstall-trigger", scriptPath));
                scriptTemplateRenderer.render(scriptTemplate, scriptFile2);
                builder.addTrigger(scriptFile2, trigger.getPreInstallProgram(), depends, 0x2000000);
            }
            if (null != (scriptTemplate = trigger.getPostInstallScriptFile())) {
                scriptFile2 = new File(String.format("%s-postinstall-trigger", scriptPath));
                scriptTemplateRenderer.render(scriptTemplate, scriptFile2);
                builder.addTrigger(scriptFile2, trigger.getPostInstallProgram(), depends, 65536);
            }
            if (null != (scriptTemplate = trigger.getPreUninstallScriptFile())) {
                scriptFile2 = new File(String.format("%s-preuninstall-trigger", scriptPath));
                scriptTemplateRenderer.render(scriptTemplate, scriptFile2);
                builder.addTrigger(scriptFile2, trigger.getPreUninstallProgram(), depends, 131072);
            }
            if (null == (scriptTemplate = trigger.getPostUninstallScriptFile())) continue;
            scriptFile2 = new File(String.format("%s-postuninstall-trigger", scriptPath));
            scriptTemplateRenderer.render(scriptTemplate, scriptFile2);
            builder.addTrigger(scriptFile2, trigger.getPostUninstallProgram(), depends, 262144);
        }
        String keyFileName = this.getSigningKey();
        if (null != keyFileName) {
            File keyFile = new File(keyFileName);
            if (!keyFile.exists()) {
                throw new SigningKeyFileNotFoundException(keyFileName);
            }
            String keyPassPhrase = this.getSigningKeyPassPhrase();
            if (null != keyPassPhrase && !keyPassPhrase.equals("")) {
                builder.setPrivateKeyPassphrase(keyPassPhrase);
            }
            builder.setPrivateKeyId(this.getSigningKeyId());
            builder.setPrivateKeyRingFile(keyFile);
        }
        this.getLog().debug((CharSequence)"Adding files matched from each rule.");
        for (RpmPackageRule packageRule : this.getRules()) {
            Collections.addAll(fileList, packageRule.addFiles(builder));
        }
        String rpmFileName = String.format("%s%s%s", buildDirectory, File.separator, this.getFinalName());
        this.getLog().info((CharSequence)String.format("Generating RPM file %s", rpmFileName));
        File packageFile = new File(rpmFileName);
        FileOutputStream packageOutputStream = new FileOutputStream(packageFile);
        builder.build(packageOutputStream.getChannel());
        RpmMojo mojo = this.getMojo();
        if (mojo.getProjectPackagingType().equals("rpm") && mojo.getProjectArtifactId().equals(this.getName()) && mojo.getProjectVersion().equals(this.getProjectVersion())) {
            this.getLog().info((CharSequence)String.format("Attaching %s as primary artifact", packageFile.getCanonicalPath()));
            mojo.setPrimaryArtifact(packageFile, this.getClassifier());
        } else if (this.isAttach()) {
            this.getLog().info((CharSequence)String.format("Attaching %s as secondary artifact", packageFile.getCanonicalPath()));
            mojo.addSecondaryArtifact(packageFile, this.getName(), this.getProjectVersion(), this.getClassifier());
        }
        return fileList;
    }

    public Set<String> listFiles() throws AbstractRpmException {
        int counter = 1;
        HashSet<String> fileList = new HashSet<String>();
        this.getMojo().getLog().info((CharSequence)String.format("    Package: %s", this.getFinalName()));
        for (RpmPackageRule packageRule : this.getRules()) {
            this.getMojo().getLog().info((CharSequence)String.format("        \\ Rule: %d", counter++));
            String[] packageRuleFileList = packageRule.listFiles();
            String scanPath = packageRule.getScanPath();
            for (String packageRulefileName : packageRuleFileList) {
                this.getMojo().getLog().info((CharSequence)String.format("            - %s/%s", scanPath, packageRulefileName));
            }
            Collections.addAll(fileList, packageRuleFileList);
        }
        this.getMojo().getLog().info((CharSequence)"");
        return fileList;
    }
}

