/*
 * Decompiled with CFR 0.152.
 */
package tv.wunderbox.nfd.nfd.jna;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.wunderbox.nfd.nfd.jna.Extractor;
import tv.wunderbox.nfd.nfd.jna.NfdLibraryNativeKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"NFD_OS_DIR_PREFIX", "", "NFD_OS_FILE_FILENAME", "NFD_RES_FILENAME_LINUX", "NFD_RES_FILENAME_MAC", "NFD_RES_FILENAME_WIN", "libraryFile", "Ljava/io/File;", "getLibraryFile", "()Ljava/io/File;", "libraryFile$delegate", "Lkotlin/Lazy;", "extractLibrary", "filename", "nativefiledialog-java"})
public final class NfdLibraryNativeKt {
    @NotNull
    private static final String NFD_RES_FILENAME_WIN = "libnfd_win.dll";
    @NotNull
    private static final String NFD_RES_FILENAME_LINUX = "libnfd_linux.so";
    @NotNull
    private static final String NFD_RES_FILENAME_MAC = "libnfd_mac.dylib";
    @NotNull
    private static final String NFD_OS_DIR_PREFIX = "libnfd";
    @NotNull
    private static final String NFD_OS_FILE_FILENAME = "libnfd";
    @NotNull
    private static final Lazy libraryFile$delegate = LazyKt.lazy(libraryFile.2.INSTANCE);

    private static final File getLibraryFile() {
        Lazy lazy = libraryFile$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File extractLibrary(String filename) {
        File outDir = Files.createTempDirectory("libnfd", new FileAttribute[0]).toFile();
        Intrinsics.checkNotNullExpressionValue(outDir, "outDir");
        File outFile = FilesKt.resolve(outDir, "libnfd");
        outFile.deleteOnExit();
        Closeable closeable = new FileOutputStream(outFile);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            InputStream inputStream = Extractor.class.getClassLoader().getResourceAsStream(filename);
            Intrinsics.checkNotNull(inputStream);
            long l = ByteStreamsKt.copyTo$default(inputStream, it, 0, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        outFile.setExecutable(true, false);
        return outFile;
    }

    public static final /* synthetic */ File access$getLibraryFile() {
        return NfdLibraryNativeKt.getLibraryFile();
    }

    public static final /* synthetic */ File access$extractLibrary(String filename) {
        return NfdLibraryNativeKt.extractLibrary(filename);
    }
}

