/*
 * Decompiled with CFR 0.152.
 */
package securesocial.core.java;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import play.libs.F;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import play.twirl.api.Html;
import securesocial.core.java.SecureSocial;
import securesocial.core.java.SecuredActionResponses;
import securesocial.views.html.notAuthorized;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultSecuredActionResponses
extends Controller
implements SecuredActionResponses {
    @Override
    public Html notAuthorizedPage(Http.Context ctx) {
        return notAuthorized.render(ctx._requestHeader(), (Lang)ctx.lang(), SecureSocial.env());
    }

    @Override
    public F.Promise<Result> notAuthenticatedResult(Http.Context ctx) {
        Results.Status result;
        Http.Request req = ctx.request();
        if (req.accepts("text/html")) {
            ctx.flash().put("error", Messages.get((String)"securesocial.loginRequired", (Object[])new Object[0]));
            ctx.session().put("original-url", ctx.request().uri());
            result = DefaultSecuredActionResponses.redirect((String)SecureSocial.env().routes().loginPageUrl(ctx._requestHeader()));
        } else if (req.accepts("application/json")) {
            ObjectNode node = Json.newObject();
            node.put("error", "Credentials required");
            result = DefaultSecuredActionResponses.unauthorized((JsonNode)node);
        } else {
            result = DefaultSecuredActionResponses.unauthorized((String)"Credentials required");
        }
        return F.Promise.pure((Object)result);
    }

    @Override
    public F.Promise<Result> notAuthorizedResult(Http.Context ctx) {
        Results.Status result;
        Http.Request req = ctx.request();
        if (req.accepts("text/html")) {
            result = DefaultSecuredActionResponses.forbidden((Content)this.notAuthorizedPage(ctx));
        } else if (req.accepts("application/json")) {
            ObjectNode node = Json.newObject();
            node.put("error", "Not authorized");
            result = DefaultSecuredActionResponses.forbidden((JsonNode)node);
        } else {
            result = DefaultSecuredActionResponses.forbidden((String)"Not authorized");
        }
        return F.Promise.pure((Object)result);
    }
}

