/*
 * Decompiled with CFR 0.152.
 */
package securesocial.core.java;

import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.Scala;
import scala.Option;
import scala.concurrent.Future;
import securesocial.core.BasicProfile;
import securesocial.core.PasswordInfo;
import securesocial.core.java.Token;
import securesocial.core.providers.MailToken;
import securesocial.core.services.SaveMode;
import securesocial.core.services.UserService;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class BaseUserService<U>
implements UserService<U> {
    protected BaseUserService() {
    }

    @Override
    public Future<Option<BasicProfile>> find(String providerId, String userId) {
        return this.doFind(providerId, userId).map((F.Function)new F.Function<BasicProfile, Option<BasicProfile>>(){

            public Option<BasicProfile> apply(BasicProfile user) throws Throwable {
                return Scala.Option((Object)user);
            }
        }).wrapped();
    }

    @Override
    public Future<Option<BasicProfile>> findByEmailAndProvider(String email, String providerId) {
        return this.doFindByEmailAndProvider(email, providerId).map((F.Function)new F.Function<BasicProfile, Option<BasicProfile>>(){

            public Option<BasicProfile> apply(BasicProfile user) throws Throwable {
                return Scala.Option((Object)user);
            }
        }).wrapped();
    }

    @Override
    public Future<U> save(BasicProfile user, SaveMode mode) {
        return this.doSave(user, mode).wrapped();
    }

    @Override
    public Future<U> link(U current, BasicProfile to) {
        return this.doLink(current, to).wrapped();
    }

    @Override
    public Future<Option<PasswordInfo>> passwordInfoFor(U user) {
        return this.doPasswordInfoFor(user).map((F.Function)new F.Function<PasswordInfo, Option<PasswordInfo>>(){

            public Option<PasswordInfo> apply(PasswordInfo passwordInfo) throws Throwable {
                return Scala.Option((Object)passwordInfo);
            }
        }).wrapped();
    }

    @Override
    public Future<Option<BasicProfile>> updatePasswordInfo(U user, PasswordInfo info) {
        return this.doUpdatePasswordInfo(user, info).map((F.Function)new F.Function<BasicProfile, Option<BasicProfile>>(){

            public Option<BasicProfile> apply(BasicProfile basicProfile) throws Throwable {
                return Scala.Option((Object)basicProfile);
            }
        }).wrapped();
    }

    @Override
    public Future<MailToken> saveToken(MailToken mailToken) {
        return this.doSaveToken(Token.fromScala(mailToken)).map((F.Function)new F.Function<Token, MailToken>(){

            public MailToken apply(Token token) throws Throwable {
                return token.toScala();
            }
        }).wrapped();
    }

    @Override
    public Future<Option<MailToken>> findToken(String token) {
        return this.doFindToken(token).map((F.Function)new F.Function<Token, Option<MailToken>>(){

            public Option<MailToken> apply(Token token) throws Throwable {
                MailToken scalaToken = token != null ? token.toScala() : null;
                return Scala.Option((Object)scalaToken);
            }
        }).wrapped();
    }

    @Override
    public Future<Option<MailToken>> deleteToken(String uuid) {
        return this.doDeleteToken(uuid).map((F.Function)new F.Function<Token, Option<MailToken>>(){

            public Option<MailToken> apply(Token token) throws Throwable {
                MailToken scalaToken = token != null ? token.toScala() : null;
                return Scala.Option((Object)scalaToken);
            }
        }).wrapped();
    }

    @Override
    public void deleteExpiredTokens() {
        this.doDeleteExpiredTokens();
    }

    public abstract F.Promise<U> doSave(BasicProfile var1, SaveMode var2);

    public abstract F.Promise<Token> doSaveToken(Token var1);

    public abstract F.Promise<U> doLink(U var1, BasicProfile var2);

    public abstract F.Promise<BasicProfile> doFind(String var1, String var2);

    public abstract F.Promise<PasswordInfo> doPasswordInfoFor(U var1);

    public abstract F.Promise<BasicProfile> doUpdatePasswordInfo(U var1, PasswordInfo var2);

    public abstract F.Promise<Token> doFindToken(String var1);

    public abstract F.Promise<BasicProfile> doFindByEmailAndProvider(String var1, String var2);

    public abstract F.Promise<Token> doDeleteToken(String var1);

    public abstract void doDeleteExpiredTokens();
}

