/*
 * Decompiled with CFR 0.152.
 */
package securesocial.core.java;

import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import scala.Option;
import scala.runtime.BoxedUnit;
import securesocial.core.RuntimeEnvironment;
import securesocial.core.authenticator.Authenticator;
import securesocial.core.java.Authorization;
import securesocial.core.java.SecureSocial;
import securesocial.core.java.SecuredAction;
import securesocial.core.java.SecuredActionResponses;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Secured
extends Action<SecuredAction> {
    private RuntimeEnvironment env;
    private Authorization authorizationInstance;
    private SecuredActionResponses responses;

    public Secured(RuntimeEnvironment<?> env) throws Throwable {
        this.env = env;
    }

    static void initEnv(RuntimeEnvironment env) throws IllegalAccessException, InstantiationException {
        if (SecureSocial.env() == null) {
            Http.Context.current().args.put("securesocial-env", env);
        }
    }

    public F.Promise<Result> call(final Http.Context ctx) throws Throwable {
        Secured.initEnv(this.env);
        this.authorizationInstance = ((SecuredAction)this.configuration).authorization().newInstance();
        this.responses = ((SecuredAction)this.configuration).responses().newInstance();
        return F.Promise.wrap(this.env.authenticatorService().fromRequest(ctx._requestHeader())).flatMap((F.Function)new F.Function<Option<Authenticator>, F.Promise<Result>>(){

            public F.Promise<Result> apply(Option<Authenticator> authenticatorOption) throws Throwable {
                if (authenticatorOption.isDefined() && ((Authenticator)authenticatorOption.get()).isValid()) {
                    Authenticator authenticator = (Authenticator)authenticatorOption.get();
                    Object user = authenticator.user();
                    if (Secured.this.authorizationInstance.isAuthorized(user, ((SecuredAction)Secured.this.configuration).params())) {
                        return F.Promise.wrap(authenticator.touch()).flatMap((F.Function)new F.Function<Authenticator, F.Promise<Result>>(){

                            public F.Promise<Result> apply(Authenticator touched) throws Throwable {
                                ctx.args.put("securesocial.user", touched.user());
                                return F.Promise.wrap(touched.touching(ctx)).flatMap((F.Function)new F.Function<BoxedUnit, F.Promise<Result>>(){

                                    public F.Promise<Result> apply(BoxedUnit unit) throws Throwable {
                                        return Secured.this.delegate.call(ctx);
                                    }
                                });
                            }
                        });
                    }
                    return Secured.this.responses.notAuthorizedResult(ctx);
                }
                if (authenticatorOption.isDefined()) {
                    return F.Promise.wrap(((Authenticator)authenticatorOption.get()).discarding(ctx)).flatMap((F.Function)new F.Function<BoxedUnit, F.Promise<Result>>(){

                        public F.Promise<Result> apply(BoxedUnit unit) throws Throwable {
                            return Secured.this.responses.notAuthenticatedResult(ctx);
                        }
                    });
                }
                return Secured.this.responses.notAuthenticatedResult(ctx);
            }
        });
    }
}

