/*
 * Decompiled with CFR 0.152.
 */
package securesocial.core;

import oauth.signpost.exception.OAuthException;
import play.api.libs.json.JsValue;
import play.api.libs.oauth.OAuth;
import play.api.libs.oauth.OAuthCalculator;
import play.api.libs.oauth.RequestToken;
import play.api.libs.oauth.ServiceInfo;
import play.api.libs.ws.WSResponse;
import play.api.libs.ws.WSSignatureCalculator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import securesocial.core.OAuth1Info;
import securesocial.core.services.HttpService;

@ScalaSignature(bytes="\u0006\u0001\u0005mcaB\u0001\u0003!\u0003\r\na\u0002\u0002\r\u001f\u0006+H\u000f[\u0019DY&,g\u000e\u001e\u0006\u0003\u0007\u0011\tAaY8sK*\tQ!\u0001\u0007tK\u000e,(/Z:pG&\fGn\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0019\u0005\u0001#\u0001\u000bsKR\u0014\u0018.\u001a<f%\u0016\fX/Z:u)>\\WM\u001c\u000b\u0003#\r\u00022AE\u000b\u0018\u001b\u0005\u0019\"B\u0001\u000b\u000b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003-M\u0011aAR;ukJ,\u0007C\u0001\r\"\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0015y\u0017-\u001e;i\u0015\taR$\u0001\u0003mS\n\u001c(B\u0001\u0010 \u0003\r\t\u0007/\u001b\u0006\u0002A\u0005!\u0001\u000f\\1z\u0013\t\u0011\u0013D\u0001\u0007SKF,Xm\u001d;U_.,g\u000eC\u0003%\u001d\u0001\u0007Q%A\u0006dC2d'-Y2l+Jc\u0005C\u0001\u0014*\u001d\tIq%\u0003\u0002)\u0015\u00051\u0001K]3eK\u001aL!AK\u0016\u0003\rM#(/\u001b8h\u0015\tA#\u0002C\u0003.\u0001\u0019\u0005a&\u0001\nsKR\u0014\u0018.\u001a<f\u001f\u0006+H\u000f[\u0019J]\u001a|GcA\u00185mA\u0019!#\u0006\u0019\u0011\u0005E\u0012T\"\u0001\u0002\n\u0005M\u0012!AC(BkRD\u0017'\u00138g_\")Q\u0007\fa\u0001/\u0005)Ao\\6f]\")q\u0007\fa\u0001K\u0005Aa/\u001a:jM&,'\u000fC\u0003:\u0001\u0019\u0005!(A\u0006sK\u0012L'/Z2u+JdGCA\u0013<\u0011\u0015)\u0004\b1\u0001&\u0011\u0015i\u0004A\"\u0001?\u0003=\u0011X\r\u001e:jKZ,\u0007K]8gS2,GcA G\u0011B\u0019!#\u0006!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r[\u0012\u0001\u00026t_:L!!\u0012\"\u0003\u000f)\u001bh+\u00197vK\")q\t\u0010a\u0001K\u0005\u0019QO\u001d7\t\u000b%c\u0004\u0019\u0001\u0019\u0002\t%tgm\u001c\u0005\u0006\u0017\u00021\u0019\u0001T\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012!\u0014\t\u0003%9K!aT\n\u0003!\u0015CXmY;uS>t7i\u001c8uKb$x!B)\u0003\u0011\u0003\u0011\u0016\u0001D(BkRD\u0017g\u00117jK:$\bCA\u0019T\r\u0015\t!\u0001#\u0001U'\t\u0019\u0006\u0002C\u0003W'\u0012\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u0002%\u001a!\u0011l\u0015\u0001[\u0005\u001d!UMZ1vYR\u001c2\u0001\u0017\u0005\\!\t\t\u0004\u0001\u0003\u0005^1\n\u0015\r\u0011\"\u0001_\u0003-\u0019XM\u001d<jG\u0016LeNZ8\u0016\u0003}\u0003\"\u0001\u00071\n\u0005\u0005L\"aC*feZL7-Z%oM>D\u0001b\u0019-\u0003\u0002\u0003\u0006IaX\u0001\rg\u0016\u0014h/[2f\u0013:4w\u000e\t\u0005\tKb\u0013)\u0019!C\u0001M\u0006Y\u0001\u000e\u001e;q'\u0016\u0014h/[2f+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016\u0003\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018B\u00017j\u0005-AE\u000f\u001e9TKJ4\u0018nY3\t\u00119D&\u0011!Q\u0001\n\u001d\fA\u0002\u001b;uaN+'O^5dK\u0002B\u0001b\u0013-\u0003\u0006\u0004%\u0019\u0001\u0014\u0005\tcb\u0013\t\u0011)A\u0005\u001b\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\t\u000bYCF\u0011A:\u0015\u0007QD\u0018\u0010\u0006\u0002voB\u0011a\u000fW\u0007\u0002'\")1J\u001da\u0002\u001b\")QL\u001da\u0001?\")QM\u001da\u0001O\"A1\u0010\u0017b\u0001\n\u0003\u0011A0\u0001\u0004dY&,g\u000e^\u000b\u0002{B\u0011\u0001D`\u0005\u0003\u007ff\u0011QaT!vi\"Dq!a\u0001YA\u0003%Q0A\u0004dY&,g\u000e\u001e\u0011\t\reBF\u0011IA\u0004)\r)\u0013\u0011\u0002\u0005\u0007k\u0005\u0015\u0001\u0019A\u0013\t\u000f\u00055\u0001\f\"\u0003\u0002\u0010\u0005Qq/\u001b;i\rV$XO]3\u0015\u0007E\t\t\u0002C\u0005\u0002\u0014\u0005-A\u00111\u0001\u0002\u0016\u0005!1-\u00197m!\u0015I\u0011qCA\u000e\u0013\r\tIB\u0003\u0002\ty\tLh.Y7f}A9\u0011QDA\u0017\u0003g9b\u0002BA\u0010\u0003SqA!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K1\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\r\tYCC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty#!\r\u0003\r\u0015KG\u000f[3s\u0015\r\tYC\u0003\t\u0005\u0003k\t\t%\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003%)\u0007pY3qi&|gN\u0003\u0003\u0002>\u0005}\u0012\u0001C:jO:\u0004xn\u001d;\u000b\u0003iIA!a\u0011\u00028\tqq*Q;uQ\u0016C8-\u001a9uS>t\u0007BB\u0017Y\t\u0003\n9\u0005F\u00030\u0003\u0013\nY\u0005\u0003\u00046\u0003\u000b\u0002\ra\u0006\u0005\u0007o\u0005\u0015\u0003\u0019A\u0013\t\r=AF\u0011IA()\r\t\u0012\u0011\u000b\u0005\u0007I\u00055\u0003\u0019A\u0013\t\ruBF\u0011IA+)\u0015y\u0014qKA-\u0011\u00199\u00151\u000ba\u0001K!1\u0011*a\u0015A\u0002A\u0002")
public interface OAuth1Client {
    public Future<RequestToken> retrieveRequestToken(String var1);

    public Future<OAuth1Info> retrieveOAuth1Info(RequestToken var1, String var2);

    public String redirectUrl(String var1);

    public Future<JsValue> retrieveProfile(String var1, OAuth1Info var2);

    public ExecutionContext executionContext();

    public static class Default
    implements OAuth1Client {
        private final ServiceInfo serviceInfo;
        private final HttpService httpService;
        private final ExecutionContext executionContext;
        private final OAuth client;

        public ServiceInfo serviceInfo() {
            return this.serviceInfo;
        }

        public HttpService httpService() {
            return this.httpService;
        }

        @Override
        public ExecutionContext executionContext() {
            return this.executionContext;
        }

        public OAuth client() {
            return this.client;
        }

        @Override
        public String redirectUrl(String token) {
            return this.client().redirectUrl(token);
        }

        private Future<RequestToken> withFuture(Function0<Either<OAuthException, RequestToken>> call) {
            return Future$.MODULE$.apply((Function0)new Serializable(this, call){
                private final Function0 call$1;

                public final RequestToken apply() {
                    Either either = (Either)this.call$1.apply();
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        OAuthException error = (OAuthException)left.a();
                        throw error;
                    }
                    if (either instanceof Right) {
                        RequestToken token;
                        Right right = (Right)either;
                        RequestToken requestToken = token = (RequestToken)right.b();
                        return requestToken;
                    }
                    throw new MatchError((Object)either);
                }
                {
                    this.call$1 = call$1;
                }
            }, this.executionContext());
        }

        @Override
        public Future<OAuth1Info> retrieveOAuth1Info(RequestToken token, String verifier) {
            return this.withFuture((Function0<Either<OAuthException, RequestToken>>)new Serializable(this, token, verifier){
                private final /* synthetic */ Default $outer;
                private final RequestToken token$1;
                private final String verifier$1;

                public final Either<OAuthException, RequestToken> apply() {
                    return this.$outer.client().retrieveAccessToken(this.token$1, this.verifier$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.token$1 = token$1;
                    this.verifier$1 = verifier$1;
                }
            }).map((Function1)new Serializable(this){

                public final OAuth1Info apply(RequestToken accessToken) {
                    return new OAuth1Info(accessToken.token(), accessToken.secret());
                }
            }, this.executionContext());
        }

        @Override
        public Future<RequestToken> retrieveRequestToken(String callbackURL) {
            return this.withFuture((Function0<Either<OAuthException, RequestToken>>)new Serializable(this, callbackURL){
                private final /* synthetic */ Default $outer;
                private final String callbackURL$1;

                public final Either<OAuthException, RequestToken> apply() {
                    return this.$outer.client().retrieveRequestToken(this.callbackURL$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.callbackURL$1 = callbackURL$1;
                }
            });
        }

        @Override
        public Future<JsValue> retrieveProfile(String url, OAuth1Info info) {
            return this.httpService().url(url).sign((WSSignatureCalculator)new OAuthCalculator(this.serviceInfo().key(), new RequestToken(info.token(), info.secret()))).get().map((Function1)new Serializable(this){

                public final JsValue apply(WSResponse x$1) {
                    return x$1.json();
                }
            }, this.executionContext());
        }

        public Default(ServiceInfo serviceInfo, HttpService httpService, ExecutionContext executionContext) {
            this.serviceInfo = serviceInfo;
            this.httpService = httpService;
            this.executionContext = executionContext;
            this.client = new OAuth(serviceInfo, true);
        }
    }
}

