/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.updatebyquery;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.updatebyquery.BulkResponseOption;
import org.elasticsearch.action.updatebyquery.IndexUpdateByQueryResponse;
import org.elasticsearch.action.updatebyquery.UpdateByQueryRequest;
import org.elasticsearch.action.updatebyquery.UpdateByQueryResponse;
import org.elasticsearch.action.updatebyquery.UpdateByQuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.UpdateByQueryClient;
import org.elasticsearch.client.UpdateByQueryClientWrapper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestUpdateByQueryAction
extends BaseRestHandler {
    protected final UpdateByQueryClient updateByQueryClient;

    @Inject
    public RestUpdateByQueryAction(Settings settings, Client client, RestController controller) {
        super(settings, controller, client);
        this.updateByQueryClient = new UpdateByQueryClientWrapper(client);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_update_by_query", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_update_by_query", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        String responseType;
        String consistencyLevel;
        UpdateByQueryRequest udqRequest = new UpdateByQueryRequest(Strings.splitStringByCommaToArray((String)request.param("index")), Strings.splitStringByCommaToArray((String)request.param("type")));
        udqRequest.listenerThreaded(false);
        String replicationType = request.param("replication");
        if (replicationType != null) {
            udqRequest.replicationType(ReplicationType.fromString((String)replicationType));
        }
        if ((consistencyLevel = request.param("consistency")) != null) {
            udqRequest.consistencyLevel(WriteConsistencyLevel.fromString((String)consistencyLevel));
        }
        if ((responseType = request.param("response")) != null) {
            udqRequest.bulkResponseOptions(BulkResponseOption.fromString(responseType));
        }
        udqRequest.routing(request.param("routing"));
        String timeout = request.param("timeout");
        if (timeout != null) {
            udqRequest.timeout(TimeValue.parseTimeValue((String)timeout, null));
        }
        if (request.hasContent()) {
            udqRequest.source(request.content(), request.contentUnsafe());
        } else if (request.hasParam("source")) {
            udqRequest.source((BytesReference)new BytesArray(request.param("source")), false);
        } else if (request.hasParam("q")) {
            UpdateByQuerySourceBuilder sourceBuilder = new UpdateByQuerySourceBuilder();
            sourceBuilder.script(request.param("script"));
            sourceBuilder.scriptFile(request.param("script_file"));
            sourceBuilder.scriptLang(request.param("lang"));
            for (Map.Entry entry : request.params().entrySet()) {
                if (!((String)entry.getKey()).startsWith("sp_")) continue;
                sourceBuilder.addScriptParam(((String)entry.getKey()).substring(3), (String)entry.getValue());
            }
            sourceBuilder.query(RestActions.parseQuerySource((RestRequest)request).buildAsBytes(XContentType.JSON));
            udqRequest.source(sourceBuilder);
        }
        this.updateByQueryClient.updateByQuery(udqRequest, (ActionListener<UpdateByQueryResponse>)new RestBuilderListener<UpdateByQueryResponse>(channel){

            public RestResponse buildResponse(UpdateByQueryResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field(Fields.OK, !response.hasFailures());
                builder.field(Fields.TOOK, response.tookInMillis());
                builder.field(Fields.TOTAL, response.totalHits());
                builder.field(Fields.UPDATED, response.updated());
                if (response.hasFailures()) {
                    builder.startArray(Fields.ERRORS);
                    for (String string : response.mainFailures()) {
                        builder.field(Fields.ERROR, string);
                    }
                    builder.endArray();
                }
                if (response.indexResponses().length != 0) {
                    builder.startArray(Fields.INDICES);
                    for (IndexUpdateByQueryResponse indexUpdateByQueryResponse : response.indexResponses()) {
                        builder.startObject();
                        builder.field(indexUpdateByQueryResponse.index());
                        builder.startObject();
                        for (Map.Entry<Integer, BulkItemResponse[]> entry : indexUpdateByQueryResponse.responsesByShard().entrySet()) {
                            builder.startObject(entry.getKey().toString());
                            if (indexUpdateByQueryResponse.failuresByShard().containsKey(entry.getKey())) {
                                builder.field(Fields.ERROR, indexUpdateByQueryResponse.failuresByShard().get(entry.getKey()));
                            }
                            builder.startArray(Fields.ITEMS);
                            for (BulkItemResponse itemResponse : entry.getValue()) {
                                builder.startObject();
                                builder.startObject(itemResponse.getOpType());
                                builder.field(Fields._INDEX, itemResponse.getIndex());
                                builder.field(Fields._TYPE, itemResponse.getType());
                                builder.field(Fields._ID, itemResponse.getId());
                                long version = itemResponse.getVersion();
                                if (version != -1L) {
                                    builder.field(Fields._VERSION, itemResponse.getVersion());
                                }
                                if (itemResponse.isFailed()) {
                                    builder.field(Fields.ERROR, itemResponse.getFailure().getMessage());
                                } else {
                                    builder.field(Fields.OK, true);
                                }
                                builder.endObject();
                                builder.endObject();
                            }
                            builder.endArray();
                            builder.endObject();
                        }
                        for (Map.Entry<Integer, Object> entry : indexUpdateByQueryResponse.failuresByShard().entrySet()) {
                            builder.startObject(entry.getKey().toString());
                            builder.field(Fields.ERROR, (String)entry.getValue());
                            builder.endObject();
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endArray();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString OK = new XContentBuilderString("ok");
        static final XContentBuilderString ERRORS = new XContentBuilderString("errors");
        static final XContentBuilderString ERROR = new XContentBuilderString("error");
        static final XContentBuilderString TOOK = new XContentBuilderString("took");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString UPDATED = new XContentBuilderString("updated");
        static final XContentBuilderString ITEMS = new XContentBuilderString("items");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");

        Fields() {
        }
    }
}

