/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class UpdateByQuerySourceBuilder
implements ToXContent {
    private QueryBuilder queryBuilder;
    private BytesReference queryBinary;
    private String script;
    private String scriptFile;
    private String scriptLang;
    private Map<String, Object> scriptParams = Maps.newHashMap();

    public UpdateByQuerySourceBuilder query(QueryBuilder query) {
        this.queryBuilder = query;
        return this;
    }

    public UpdateByQuerySourceBuilder query(BytesReference queryBinary) {
        this.queryBinary = queryBinary;
        return this;
    }

    public UpdateByQuerySourceBuilder script(String script) {
        this.script = script;
        return this;
    }

    public UpdateByQuerySourceBuilder scriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
        return this;
    }

    public UpdateByQuerySourceBuilder scriptLang(String scriptLang) {
        this.scriptLang = scriptLang;
        return this;
    }

    public UpdateByQuerySourceBuilder scriptParams(Map<String, Object> scriptParams) {
        this.scriptParams = scriptParams;
        return this;
    }

    public UpdateByQuerySourceBuilder addScriptParam(String name, String value) {
        this.scriptParams.put(name, value);
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.queryBinary != null) {
            if (XContentFactory.xContentType((BytesReference)this.queryBinary) == builder.contentType()) {
                builder.rawField("query", this.queryBinary);
            } else {
                builder.field("query_binary", this.queryBinary);
            }
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.scriptFile != null) {
            builder.field("script_file", this.scriptFile);
        }
        if (this.scriptLang != null) {
            builder.field("lang", this.scriptLang);
        }
        if (!this.scriptParams.isEmpty()) {
            builder.field("params", this.scriptParams);
        }
        builder.endObject();
        return builder;
    }

    public BytesReference buildAsBytes(XContentType contentType) throws SearchSourceBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.bytes();
        }
        catch (Exception e) {
            throw new SearchSourceBuilderException("Failed to build search source", (Throwable)e);
        }
    }
}

