/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.updatebyquery.ShardUpdateByQueryResponse;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexUpdateByQueryResponse
extends ActionResponse {
    private String index;
    private long totalHits;
    private long updated;
    private Map<Integer, BulkItemResponse[]> responsesByShard = Maps.newHashMap();
    private Map<Integer, String> failuresByShard = Maps.newHashMap();

    IndexUpdateByQueryResponse() {
    }

    public IndexUpdateByQueryResponse(String index, ShardUpdateByQueryResponse[] shardResponses) {
        this.index = index;
        this.shardResponses(shardResponses);
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public IndexUpdateByQueryResponse index(String index) {
        this.index = index;
        return this;
    }

    public IndexUpdateByQueryResponse shardResponses(ShardUpdateByQueryResponse[] responses) {
        for (ShardUpdateByQueryResponse response : responses) {
            this.totalHits += (long)response.totalHits();
            this.updated += (long)response.updated();
            if (response.failedShardExceptionMessage() != null) {
                this.failuresByShard.put(response.shardId(), response.failedShardExceptionMessage());
            }
            if (response.bulkResponses().length == 0) continue;
            this.responsesByShard.put(response.shardId(), response.bulkResponses());
        }
        return this;
    }

    public Map<Integer, BulkItemResponse[]> responsesByShard() {
        return this.responsesByShard;
    }

    public Map<Integer, String> failuresByShard() {
        return this.failuresByShard;
    }

    public long totalHits() {
        return this.totalHits;
    }

    public long updated() {
        return this.updated;
    }

    public long countShardResponses() {
        long count = 0L;
        for (BulkItemResponse[] bulkItemResponses : this.responsesByShard.values()) {
            count += (long)bulkItemResponses.length;
        }
        return count;
    }

    public boolean hasFailures() {
        return !this.failuresByShard.isEmpty();
    }

    public void readFrom(StreamInput in) throws IOException {
        int shardId;
        int i;
        super.readFrom(in);
        this.index = in.readString();
        this.totalHits = in.readVLong();
        this.updated = in.readVLong();
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            shardId = in.readVInt();
            BulkItemResponse[] responses = new BulkItemResponse[in.readVInt()];
            for (int j = 0; j < responses.length; ++j) {
                responses[j] = BulkItemResponse.readBulkItem((StreamInput)in);
            }
            this.responsesByShard.put(shardId, responses);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            shardId = in.readVInt();
            this.failuresByShard.put(shardId, in.readString());
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeVLong(this.totalHits);
        out.writeVLong(this.updated);
        out.writeVInt(this.responsesByShard.size());
        for (Map.Entry<Integer, BulkItemResponse[]> entry : this.responsesByShard.entrySet()) {
            out.writeVInt(entry.getKey().intValue());
            out.writeVInt(entry.getValue().length);
            for (BulkItemResponse bulkItemResponse : entry.getValue()) {
                bulkItemResponse.writeTo(out);
            }
        }
        out.writeVInt(this.failuresByShard.size());
        for (Map.Entry<Integer, Object> entry : this.failuresByShard.entrySet()) {
            out.writeVInt(entry.getKey().intValue());
            out.writeString((String)entry.getValue());
        }
    }

    public static IndexUpdateByQueryResponse readResponseItem(StreamInput in) throws IOException {
        IndexUpdateByQueryResponse response = new IndexUpdateByQueryResponse();
        response.readFrom(in);
        return response;
    }
}

