/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.util.Set;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.IndexReplicationOperationRequest;
import org.elasticsearch.action.updatebyquery.BulkResponseOption;
import org.elasticsearch.action.updatebyquery.UpdateByQueryRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Sets;

public class IndexUpdateByQueryRequest
extends IndexReplicationOperationRequest<IndexUpdateByQueryRequest> {
    private String[] types = new String[0];
    private BulkResponseOption bulkResponseOption;
    private String[] filteringAliases = new String[0];
    private Set<String> routing = Sets.newHashSet();
    private BytesReference source;
    private boolean sourceUnsafe;
    private long nowInMillis;

    IndexUpdateByQueryRequest(UpdateByQueryRequest request, String index, String[] filteringAliases, Set<String> routing) {
        super(index, request.timeout(), request.replicationType(), request.consistencyLevel(), request.indices(), request.indicesOptions(), (ActionRequest)request);
        this.listenerThreaded(request.listenerThreaded());
        this.types = request.types();
        this.bulkResponseOption = request.bulkResponseOptions();
        this.source = request.source();
        this.sourceUnsafe = request.sourceUnsafe();
        this.nowInMillis = request.nowInMillis;
        if (filteringAliases != null) {
            this.filteringAliases = filteringAliases;
        }
        if (routing != null) {
            this.routing = routing;
        }
    }

    public String[] types() {
        return this.types;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    public BulkResponseOption bulkResponseOptions() {
        return this.bulkResponseOption;
    }

    public Set<String> routing() {
        return this.routing;
    }

    public BytesReference source() {
        return this.source;
    }

    public boolean sourceUnsafe() {
        return this.sourceUnsafe;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public void beforeLocalFork() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.source == null) {
            validationException = ValidateActions.addValidationError((String)"Source is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

