/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum BulkResponseOption {
    NONE(0),
    FAILED(1),
    ALL(2);

    private byte id;

    private BulkResponseOption(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static BulkResponseOption fromId(byte id) {
        if (id == 0) {
            return NONE;
        }
        if (id == 1) {
            return FAILED;
        }
        if (id == 2) {
            return ALL;
        }
        throw new ElasticsearchIllegalArgumentException("No type match for [" + id + "]");
    }

    public static BulkResponseOption fromString(String type) {
        if ("none".equals(type)) {
            return NONE;
        }
        if ("failed".equals(type)) {
            return FAILED;
        }
        if ("all".equals(type)) {
            return ALL;
        }
        throw new ElasticsearchIllegalArgumentException("no response type match for [" + type + "], should be either `none`, `failed` or `all`");
    }
}

