/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShardUpdateByQueryResponse
extends ActionResponse {
    private int shardId;
    private int totalHits;
    private int updated;
    private BulkItemResponse[] bulkResponses = new BulkItemResponse[0];
    private String failedShardExceptionMessage;

    ShardUpdateByQueryResponse() {
    }

    public ShardUpdateByQueryResponse(int shardId) {
        this(shardId, 0, 0, new BulkItemResponse[0]);
    }

    public ShardUpdateByQueryResponse(int shardId, int totalHits, int updated, BulkItemResponse[] bulkResponses) {
        this.shardId = shardId;
        this.totalHits = totalHits;
        this.updated = updated;
        this.bulkResponses = bulkResponses;
    }

    public ShardUpdateByQueryResponse(int shardId, String failure) {
        this.shardId = shardId;
        this.failedShardExceptionMessage = failure;
    }

    public int shardId() {
        return this.shardId;
    }

    public void shardId(int shardId) {
        this.shardId = shardId;
    }

    public int updated() {
        return this.updated;
    }

    public String failedShardExceptionMessage() {
        return this.failedShardExceptionMessage;
    }

    public ShardUpdateByQueryResponse failedShardExceptionMessage(String failedShardExceptionMessage) {
        this.failedShardExceptionMessage = failedShardExceptionMessage;
        return this;
    }

    public BulkItemResponse[] bulkResponses() {
        return this.bulkResponses;
    }

    public ShardUpdateByQueryResponse responses(BulkItemResponse[] responses) {
        this.bulkResponses = responses;
        return this;
    }

    public int totalHits() {
        return this.totalHits;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardId);
        out.writeVInt(this.totalHits);
        out.writeVInt(this.updated);
        out.writeVInt(this.bulkResponses.length);
        for (BulkItemResponse response : this.bulkResponses) {
            response.writeTo(out);
        }
        out.writeOptionalString(this.failedShardExceptionMessage);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = in.readVInt();
        this.totalHits = in.readVInt();
        this.updated = in.readVInt();
        this.bulkResponses = new BulkItemResponse[in.readVInt()];
        for (int i = 0; i < this.bulkResponses.length; ++i) {
            this.bulkResponses[i] = BulkItemResponse.readBulkItem((StreamInput)in);
        }
        this.failedShardExceptionMessage = in.readOptionalString();
    }
}

