/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.FixedBitSet;

public class TopLevelFixedBitSetCollector
extends Collector {
    private final FixedBitSet bitSet;
    private int docBase;

    public TopLevelFixedBitSetCollector(int maxDoc) {
        this.bitSet = new FixedBitSet(maxDoc);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void collect(int doc) throws IOException {
        this.bitSet.set(this.docBase + doc);
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public FixedBitSet getBitSet() {
        return this.bitSet;
    }
}

