/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.updatebyquery.IndexUpdateByQueryResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UpdateByQueryResponse
extends ActionResponse {
    private long tookInMillis;
    private long totalHits;
    private long updated;
    private IndexUpdateByQueryResponse[] indexResponses = new IndexUpdateByQueryResponse[0];
    private String[] mainFailures = Strings.EMPTY_ARRAY;

    UpdateByQueryResponse() {
    }

    public UpdateByQueryResponse(long tookInMillis, IndexUpdateByQueryResponse ... indexResponses) {
        this.tookInMillis = tookInMillis;
        this.indexResponses(indexResponses);
    }

    public long tookInMillis() {
        return this.tookInMillis;
    }

    public long getTookInMillis() {
        return this.tookInMillis();
    }

    public IndexUpdateByQueryResponse[] indexResponses() {
        return this.indexResponses;
    }

    public IndexUpdateByQueryResponse[] getIndexResponses() {
        return this.indexResponses();
    }

    public UpdateByQueryResponse indexResponses(IndexUpdateByQueryResponse[] responses) {
        for (IndexUpdateByQueryResponse response : responses) {
            this.totalHits += response.totalHits();
            this.updated += response.updated();
        }
        this.indexResponses = responses;
        return this;
    }

    public String[] mainFailures() {
        return this.mainFailures;
    }

    public String[] getMainFailures() {
        return this.mainFailures();
    }

    public UpdateByQueryResponse mainFailures(String[] mainFailures) {
        this.mainFailures = mainFailures;
        return this;
    }

    public long totalHits() {
        return this.totalHits;
    }

    public long getTotalHits() {
        return this.totalHits();
    }

    public long updated() {
        return this.updated;
    }

    public long getUpdated() {
        return this.updated();
    }

    public boolean hasFailures() {
        return this.mainFailures().length != 0;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tookInMillis = in.readVLong();
        this.totalHits = in.readVLong();
        this.updated = in.readVLong();
        this.indexResponses = new IndexUpdateByQueryResponse[in.readVInt()];
        for (int i = 0; i < this.indexResponses.length; ++i) {
            this.indexResponses[i] = IndexUpdateByQueryResponse.readResponseItem(in);
        }
        this.mainFailures = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.tookInMillis);
        out.writeVLong(this.totalHits);
        out.writeVLong(this.updated);
        out.writeVInt(this.indexResponses.length);
        for (IndexUpdateByQueryResponse response : this.indexResponses) {
            response.writeTo(out);
        }
        out.writeStringArray(this.mainFailures);
    }
}

