/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequest;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequestBuilder;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.updatebyquery.BulkResponseOption;
import org.elasticsearch.action.updatebyquery.UpdateByQueryRequest;
import org.elasticsearch.action.updatebyquery.UpdateByQueryResponse;
import org.elasticsearch.action.updatebyquery.UpdateByQuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.UpdateByQueryClientWrapper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.query.QueryBuilder;

public class UpdateByQueryRequestBuilder
extends IndicesReplicationOperationRequestBuilder<UpdateByQueryRequest, UpdateByQueryResponse, UpdateByQueryRequestBuilder> {
    private final UpdateByQueryClientWrapper updateByQueryClientWrapper;
    private UpdateByQuerySourceBuilder sourceBuilder;

    public UpdateByQueryRequestBuilder(Client client) {
        super(client, (IndicesReplicationOperationRequest)new UpdateByQueryRequest());
        this.updateByQueryClientWrapper = new UpdateByQueryClientWrapper(client);
    }

    public UpdateByQueryRequestBuilder setTypes(String ... types) {
        ((UpdateByQueryRequest)this.request()).types(types);
        return this;
    }

    public UpdateByQueryRequestBuilder setIncludeBulkResponses(BulkResponseOption option) {
        ((UpdateByQueryRequest)this.request()).bulkResponseOptions(option);
        return this;
    }

    public UpdateByQueryRequestBuilder setReplicationType(ReplicationType replicationType) {
        ((UpdateByQueryRequest)this.request()).replicationType(replicationType);
        return this;
    }

    public UpdateByQueryRequestBuilder setConsistencyLevel(WriteConsistencyLevel writeConsistencyLevel) {
        ((UpdateByQueryRequest)this.request()).consistencyLevel(writeConsistencyLevel);
        return this;
    }

    public UpdateByQueryRequestBuilder setQuery(QueryBuilder queryBuilder) {
        this.sourceBuilder().query(queryBuilder);
        return this;
    }

    public UpdateByQueryRequestBuilder setQuery(BytesReference query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public UpdateByQueryRequestBuilder setScriptLang(String lang) {
        this.sourceBuilder().scriptLang(lang);
        return this;
    }

    public UpdateByQueryRequestBuilder setScript(String script) {
        this.sourceBuilder().script(script);
        return this;
    }

    public UpdateByQueryRequestBuilder setScriptParams(Map<String, Object> scriptParams) {
        if (scriptParams != null) {
            this.sourceBuilder().scriptParams(scriptParams);
        }
        return this;
    }

    public UpdateByQueryRequestBuilder addScriptParam(String name, String value) {
        this.sourceBuilder().addScriptParam(name, value);
        return this;
    }

    protected void doExecute(ActionListener<UpdateByQueryResponse> listener) {
        if (this.sourceBuilder != null) {
            ((UpdateByQueryRequest)this.request).source(this.sourceBuilder);
        }
        this.updateByQueryClientWrapper.updateByQuery((UpdateByQueryRequest)this.request, listener);
    }

    private UpdateByQuerySourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new UpdateByQuerySourceBuilder();
        }
        return this.sourceBuilder;
    }
}

