/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.updatebyquery.IndexUpdateByQueryRequest;
import org.elasticsearch.action.updatebyquery.IndexUpdateByQueryResponse;
import org.elasticsearch.action.updatebyquery.ShardUpdateByQueryRequest;
import org.elasticsearch.action.updatebyquery.ShardUpdateByQueryResponse;
import org.elasticsearch.action.updatebyquery.TransportShardUpdateByQueryAction;
import org.elasticsearch.action.updatebyquery.UpdateByQueryRequest;
import org.elasticsearch.action.updatebyquery.UpdateByQueryResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateByQueryAction
extends TransportAction<UpdateByQueryRequest, UpdateByQueryResponse> {
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final TransportShardUpdateByQueryAction transportShardUpdateByQueryAction;

    @Inject
    public TransportUpdateByQueryAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, TransportShardUpdateByQueryAction transportShardUpdateByQueryAction) {
        super(settings, "updateByQuery", threadPool, actionFilters);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.transportShardUpdateByQueryAction = transportShardUpdateByQueryAction;
        transportService.registerHandler("updateByQuery", (TransportRequestHandler)new TransportHandler());
    }

    protected void doExecute(UpdateByQueryRequest request, ActionListener<UpdateByQueryResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        MetaData metaData = this.clusterService.state().metaData();
        String[] concreteIndices = metaData.concreteIndices(IndicesOptions.lenientExpandOpen(), request.indices());
        Map routingMap = metaData.resolveSearchRouting(request.routing(), request.indices());
        if (concreteIndices.length == 1) {
            this.doExecuteIndexRequest(request, metaData, concreteIndices[0], routingMap, new SingleIndexUpdateByQueryActionListener(request.nowInMillis, listener));
        } else {
            MultipleIndexUpdateByQueryActionListener indexActionListener = new MultipleIndexUpdateByQueryActionListener(request.nowInMillis, listener, concreteIndices.length);
            for (String concreteIndex : concreteIndices) {
                this.doExecuteIndexRequest(request, metaData, concreteIndex, routingMap, indexActionListener);
            }
        }
    }

    protected void doExecuteIndexRequest(UpdateByQueryRequest request, MetaData metaData, String concreteIndex, @Nullable Map<String, Set<String>> routingMap, ActionListener<IndexUpdateByQueryResponse> listener) {
        String[] filteringAliases = metaData.filteringAliases(concreteIndex, request.indices());
        Set<String> routing = null;
        if (routingMap != null) {
            routing = routingMap.get(concreteIndex);
        }
        IndexUpdateByQueryRequest indexRequest = new IndexUpdateByQueryRequest(request, concreteIndex, filteringAliases, routing);
        new UpdateByQueryIndexOperationAction(indexRequest, listener).startExecution();
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<UpdateByQueryRequest> {
        private TransportHandler() {
        }

        public UpdateByQueryRequest newInstance() {
            return new UpdateByQueryRequest();
        }

        public String executor() {
            return "same";
        }

        public void messageReceived(UpdateByQueryRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportUpdateByQueryAction.this.doExecute(request, new ActionListener<UpdateByQueryResponse>(){

                public void onResponse(UpdateByQueryResponse result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportUpdateByQueryAction.this.logger.warn("Failed to send response for get", (Throwable)e1, new Object[0]);
                    }
                }
            });
        }
    }

    private class UpdateByQueryIndexOperationAction {
        final IndexUpdateByQueryRequest request;
        final ActionListener<IndexUpdateByQueryResponse> indexActionListener;

        private UpdateByQueryIndexOperationAction(IndexUpdateByQueryRequest request, ActionListener<IndexUpdateByQueryResponse> listener) {
            this.request = request;
            this.indexActionListener = listener;
        }

        void startExecution() {
            this.startExecution(false);
        }

        boolean startExecution(boolean fromClusterEvent) {
            ClusterState state = TransportUpdateByQueryAction.this.clusterService.state();
            ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
            if (blockException != null) {
                TransportUpdateByQueryAction.this.logger.trace("[{}] global block exception, retrying...", new Object[]{this.request.index()});
                this.overallRetry(fromClusterEvent, null, (Throwable)blockException);
                return false;
            }
            blockException = state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, this.request.index());
            if (blockException != null) {
                TransportUpdateByQueryAction.this.logger.trace("[{}] index block exception, retrying...", new Object[]{this.request.index()});
                this.overallRetry(fromClusterEvent, null, (Throwable)blockException);
                return false;
            }
            ArrayList primaryShards = Lists.newArrayList();
            GroupShardsIterator groupShardsIterator = TransportUpdateByQueryAction.this.clusterService.operationRouting().deleteByQueryShards(state, this.request.index(), this.request.routing());
            for (ShardIterator shardIt : groupShardsIterator) {
                ShardRouting shardRouting = shardIt.nextOrNull();
                while (shardRouting != null) {
                    if (shardRouting.primary()) {
                        if (shardRouting.started()) {
                            primaryShards.add(shardRouting);
                        } else {
                            TransportUpdateByQueryAction.this.logger.trace("[{}][{}] required primary shard isn't available, retrying...", new Object[]{this.request.index(), shardRouting.id()});
                            this.overallRetry(fromClusterEvent, shardRouting, null);
                            return false;
                        }
                    }
                    shardRouting = shardIt.nextOrNull();
                }
            }
            if (primaryShards.size() != groupShardsIterator.size()) {
                TransportUpdateByQueryAction.this.logger.trace("[{}] not all required primary shards[{}/{}] are available for index[{}], retrying...", new Object[]{this.request.index(), primaryShards.size(), groupShardsIterator.size()});
                this.overallRetry(fromClusterEvent, null, null);
                return false;
            }
            TransportUpdateByQueryAction.this.logger.trace("[{}] executing IndexUpdateByQueryRequest", new Object[]{this.request.index()});
            DiscoveryNodes nodes = state.nodes();
            ShardResponseListener responseListener = new ShardResponseListener(primaryShards.size(), this.indexActionListener);
            for (ShardRouting shard : primaryShards) {
                TransportUpdateByQueryAction.this.logger.trace("[{}][{}] executing ShardUpdateByQueryRequest", new Object[]{this.request.index(), shard.id()});
                if (shard.currentNodeId().equals(nodes.localNodeId())) {
                    this.executeLocally(shard, responseListener);
                    continue;
                }
                this.executeRemotely(shard, nodes, responseListener);
            }
            return true;
        }

        void overallRetry(boolean fromClusterEvent, final ShardRouting shardRouting, final @Nullable Throwable failure) {
            if (!fromClusterEvent) {
                TransportUpdateByQueryAction.this.clusterService.add(this.request.timeout(), new TimeoutClusterStateListener(){

                    public void postAdded() {
                        TransportUpdateByQueryAction.this.logger.trace("[{}] post added, retrying update by query", new Object[]{UpdateByQueryIndexOperationAction.this.request.index()});
                        if (UpdateByQueryIndexOperationAction.this.startExecution(true)) {
                            TransportUpdateByQueryAction.this.clusterService.remove((ClusterStateListener)this);
                        }
                    }

                    public void onClose() {
                        TransportUpdateByQueryAction.this.logger.trace("[{}] update by query for, node closed", new Object[]{UpdateByQueryIndexOperationAction.this.request.index()});
                        TransportUpdateByQueryAction.this.clusterService.remove((ClusterStateListener)this);
                        UpdateByQueryIndexOperationAction.this.indexActionListener.onFailure((Throwable)new NodeClosedException(TransportUpdateByQueryAction.this.clusterService.localNode()));
                    }

                    public void clusterChanged(ClusterChangedEvent event) {
                        TransportUpdateByQueryAction.this.logger.trace("[{}] cluster changed, retrying update by query", new Object[]{UpdateByQueryIndexOperationAction.this.request.index()});
                        if (UpdateByQueryIndexOperationAction.this.startExecution(true)) {
                            TransportUpdateByQueryAction.this.clusterService.remove((ClusterStateListener)this);
                        }
                    }

                    public void onTimeout(TimeValue timeValue) {
                        TransportUpdateByQueryAction.this.logger.trace("[{}] timeout, retrying update by query", new Object[]{UpdateByQueryIndexOperationAction.this.request.index()});
                        if (UpdateByQueryIndexOperationAction.this.startExecution(true)) {
                            TransportUpdateByQueryAction.this.clusterService.remove((ClusterStateListener)this);
                            return;
                        }
                        TransportUpdateByQueryAction.this.clusterService.remove((ClusterStateListener)this);
                        Throwable listenerFailure = failure;
                        if (listenerFailure == null) {
                            listenerFailure = shardRouting == null ? new UnavailableShardsException(null, "no available shards: Timeout waiting for [" + timeValue + "], request: " + ((Object)((Object)UpdateByQueryIndexOperationAction.this.request)).toString()) : new UnavailableShardsException(shardRouting.shardId(), "[" + shardRouting.shardId() + "] not started, Timeout waiting for [" + timeValue + "], request: " + ((Object)((Object)UpdateByQueryIndexOperationAction.this.request)).toString());
                        }
                        UpdateByQueryIndexOperationAction.this.indexActionListener.onFailure(listenerFailure);
                    }
                });
            }
        }

        void executeLocally(final ShardRouting shard, final ShardResponseListener responseListener) {
            ShardUpdateByQueryRequest localShardRequest = new ShardUpdateByQueryRequest(this.request, shard.id(), shard.currentNodeId());
            TransportUpdateByQueryAction.this.transportShardUpdateByQueryAction.execute((ActionRequest)localShardRequest, (ActionListener)new ActionListener<ShardUpdateByQueryResponse>(){

                public void onResponse(ShardUpdateByQueryResponse shardUpdateByQueryResponse) {
                    responseListener.handleResponse(shardUpdateByQueryResponse);
                }

                public void onFailure(Throwable e) {
                    responseListener.handleException(e, shard);
                }
            });
        }

        void executeRemotely(final ShardRouting shard, DiscoveryNodes nodes, final ShardResponseListener responseListener) {
            DiscoveryNode discoveryNode = nodes.get(shard.currentNodeId());
            if (discoveryNode == null) {
                responseListener.handleException(new RuntimeException("No node for shard"), shard);
                return;
            }
            ShardUpdateByQueryRequest localShardRequest = new ShardUpdateByQueryRequest(this.request, shard.id(), shard.currentNodeId());
            TransportUpdateByQueryAction.this.transportService.sendRequest(discoveryNode, "updateByQuery/shard", (TransportRequest)localShardRequest, (TransportResponseHandler)new BaseTransportResponseHandler<ShardUpdateByQueryResponse>(){

                public ShardUpdateByQueryResponse newInstance() {
                    return new ShardUpdateByQueryResponse();
                }

                public void handleResponse(ShardUpdateByQueryResponse response) {
                    responseListener.handleResponse(response);
                }

                public void handleException(TransportException e) {
                    responseListener.handleException((Throwable)e, shard);
                }

                public String executor() {
                    return "same";
                }
            });
        }

        private class ShardResponseListener {
            final AtomicReferenceArray<ShardUpdateByQueryResponse> shardResponses;
            final AtomicInteger indexCounter;
            final AtomicInteger completionCounter;
            final ActionListener<IndexUpdateByQueryResponse> finalListener;
            final int numberOfExpectedShardResponses;

            private ShardResponseListener(int numberOfPrimaryShards, ActionListener<IndexUpdateByQueryResponse> finalListener) {
                this.shardResponses = new AtomicReferenceArray(numberOfPrimaryShards);
                this.numberOfExpectedShardResponses = numberOfPrimaryShards;
                this.indexCounter = new AtomicInteger();
                this.completionCounter = new AtomicInteger(this.numberOfExpectedShardResponses);
                this.finalListener = finalListener;
            }

            void handleResponse(ShardUpdateByQueryResponse response) {
                this.shardResponses.set(this.indexCounter.getAndIncrement(), response);
                if (this.completionCounter.decrementAndGet() == 0) {
                    this.finalizeAction();
                }
            }

            void handleException(Throwable e, ShardRouting shard) {
                TransportUpdateByQueryAction.this.logger.error("[{}][{}] error while executing update by query shard request", e, new Object[]{UpdateByQueryIndexOperationAction.this.request.index(), shard.id()});
                String failure = ExceptionsHelper.detailedMessage((Throwable)e);
                this.shardResponses.set(this.indexCounter.getAndIncrement(), new ShardUpdateByQueryResponse(shard.id(), failure));
                if (this.completionCounter.decrementAndGet() == 0) {
                    this.finalizeAction();
                }
            }

            void finalizeAction() {
                ShardUpdateByQueryResponse[] responses = new ShardUpdateByQueryResponse[this.shardResponses.length()];
                for (int i = 0; i < this.shardResponses.length(); ++i) {
                    responses[i] = this.shardResponses.get(i);
                }
                IndexUpdateByQueryResponse finalResponse = new IndexUpdateByQueryResponse(UpdateByQueryIndexOperationAction.this.request.index(), responses);
                this.finalListener.onResponse((Object)finalResponse);
            }
        }
    }

    private static class SingleIndexUpdateByQueryActionListener
    implements ActionListener<IndexUpdateByQueryResponse> {
        private final long nowInMillis;
        private final ActionListener<UpdateByQueryResponse> listener;

        private SingleIndexUpdateByQueryActionListener(long nowInMillis, ActionListener<UpdateByQueryResponse> listener) {
            this.listener = listener;
            this.nowInMillis = nowInMillis;
        }

        public void onResponse(IndexUpdateByQueryResponse indexUpdateByQueryResponse) {
            long tookInMillis = System.currentTimeMillis() - this.nowInMillis;
            UpdateByQueryResponse finalResponse = new UpdateByQueryResponse(tookInMillis, indexUpdateByQueryResponse);
            this.listener.onResponse((Object)finalResponse);
        }

        public void onFailure(Throwable e) {
            long tookInMillis = System.currentTimeMillis() - this.nowInMillis;
            UpdateByQueryResponse finalResponse = new UpdateByQueryResponse(tookInMillis, new IndexUpdateByQueryResponse[0]);
            finalResponse.mainFailures(new String[]{ExceptionsHelper.detailedMessage((Throwable)e)});
            this.listener.onResponse((Object)finalResponse);
        }
    }

    private static class MultipleIndexUpdateByQueryActionListener
    implements ActionListener<IndexUpdateByQueryResponse> {
        private final long nowInMillis;
        private final ActionListener<UpdateByQueryResponse> listener;
        private final int expectedNumberOfResponses;
        private final AtomicReferenceArray<IndexUpdateByQueryResponse> successFullIndexResponses;
        private final AtomicReferenceArray<Throwable> failedIndexResponses;
        private final AtomicInteger indexCounter;
        private final AtomicInteger completionCounter;

        private MultipleIndexUpdateByQueryActionListener(long nowInMillis, ActionListener<UpdateByQueryResponse> listener, int expectedNumberOfResponses) {
            this.nowInMillis = nowInMillis;
            this.listener = listener;
            this.successFullIndexResponses = new AtomicReferenceArray(expectedNumberOfResponses);
            this.failedIndexResponses = new AtomicReferenceArray(expectedNumberOfResponses);
            this.expectedNumberOfResponses = expectedNumberOfResponses;
            this.indexCounter = new AtomicInteger();
            this.completionCounter = new AtomicInteger(expectedNumberOfResponses);
        }

        public void onResponse(IndexUpdateByQueryResponse indexUpdateByQueryResponse) {
            this.successFullIndexResponses.set(this.indexCounter.getAndIncrement(), indexUpdateByQueryResponse);
            if (this.completionCounter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        public void onFailure(Throwable e) {
            this.failedIndexResponses.set(this.indexCounter.getAndIncrement(), e);
            if (this.completionCounter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        private void finishHim() {
            long tookInMillis = System.currentTimeMillis() - this.nowInMillis;
            UpdateByQueryResponse response = new UpdateByQueryResponse(tookInMillis, new IndexUpdateByQueryResponse[0]);
            ArrayList indexResponses = Lists.newArrayList();
            ArrayList indexFailures = Lists.newArrayList();
            for (int i = 0; i < this.expectedNumberOfResponses; ++i) {
                IndexUpdateByQueryResponse indexResponse = this.successFullIndexResponses.get(i);
                if (indexResponse != null) {
                    indexResponses.add(indexResponse);
                    continue;
                }
                indexFailures.add(ExceptionsHelper.detailedMessage((Throwable)this.failedIndexResponses.get(i)));
            }
            response.indexResponses(indexResponses.toArray(new IndexUpdateByQueryResponse[indexResponses.size()]));
            response.mainFailures(indexFailures.toArray(new String[indexFailures.size()]));
            this.listener.onResponse((Object)response);
        }
    }
}

