/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.PublicBulkShardRequest;
import org.elasticsearch.action.bulk.PublicBulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.updatebyquery.ShardUpdateByQueryRequest;
import org.elasticsearch.action.updatebyquery.ShardUpdateByQueryResponse;
import org.elasticsearch.action.updatebyquery.UpdateByQueryContext;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.TopLevelFixedBitSetCollector;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fieldvisitor.JustUidFieldsVisitor;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportShardUpdateByQueryAction
extends TransportAction<ShardUpdateByQueryRequest, ShardUpdateByQueryResponse> {
    public static final String ACTION_NAME = "updateByQuery/shard";
    private final TransportShardBulkAction bulkAction;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final int batchSize;
    private final CacheRecycler cacheRecycler;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;

    @Inject
    public TransportShardUpdateByQueryAction(Settings settings, ThreadPool threadPool, TransportShardBulkAction bulkAction, ActionFilters actionFilters, TransportService transportService, CacheRecycler cacheRecycler, IndicesService indicesService, ClusterService clusterService, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays) {
        super(settings, ACTION_NAME, threadPool, actionFilters);
        this.bulkAction = bulkAction;
        this.cacheRecycler = cacheRecycler;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
        this.batchSize = this.componentSettings.getAsInt("bulk_size", Integer.valueOf(1000));
        transportService.registerHandler(ACTION_NAME, (TransportRequestHandler)new TransportHandler());
    }

    protected void doExecute(final ShardUpdateByQueryRequest request, final ActionListener<ShardUpdateByQueryResponse> listener) {
        String localNodeId = this.clusterService.state().nodes().localNodeId();
        if (!localNodeId.equals(request.targetNodeId())) {
            throw new ElasticsearchException("Request arrived on the wrong node. This shouldn't happen!");
        }
        if (request.operationThreaded()) {
            request.beforeLocalFork();
            this.threadPool.executor("bulk").execute(new Runnable(){

                @Override
                public void run() {
                    TransportShardUpdateByQueryAction.this.doExecuteInternal(request, (ActionListener<ShardUpdateByQueryResponse>)listener);
                }
            });
        } else {
            this.doExecuteInternal(request, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteInternal(ShardUpdateByQueryRequest request, ActionListener<ShardUpdateByQueryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        ShardSearchLocalRequest shardSearchRequest = new ShardSearchLocalRequest(request.types(), request.nowInMillis(), request.filteringAliases());
        DefaultSearchContext searchContext = new DefaultSearchContext(0L, (ShardSearchRequest)shardSearchRequest, null, indexShard.acquireSearcher("update_by_query"), indexService, indexShard, this.scriptService, this.cacheRecycler, this.pageCacheRecycler, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter());
        SearchContext.setCurrent((SearchContext)searchContext);
        try {
            UpdateByQueryContext ubqContext = this.parseRequestSource(indexService, request, (SearchContext)searchContext);
            searchContext.preProcess();
            TopLevelFixedBitSetCollector bitSetCollector = new TopLevelFixedBitSetCollector(searchContext.searcher().getIndexReader().maxDoc());
            searchContext.searcher().search(searchContext.query(), searchContext.aliasFilter(), (Collector)bitSetCollector);
            FixedBitSet docsToUpdate = bitSetCollector.getBitSet();
            int docsToUpdateCount = docsToUpdate.cardinality();
            this.logger.trace("[{}][{}] {} docs to update", new Object[]{request.index(), request.shardId(), docsToUpdateCount});
            if (docsToUpdateCount == 0) {
                ShardUpdateByQueryResponse response = new ShardUpdateByQueryResponse(request.shardId());
                listener.onResponse((Object)response);
                searchContext.close();
                return;
            }
            BatchedShardUpdateByQueryExecutor bulkExecutor = new BatchedShardUpdateByQueryExecutor(listener, docsToUpdate, request, ubqContext);
            bulkExecutor.executeBulkIndex();
        }
        catch (Throwable t) {
            searchContext.close();
            listener.onFailure(t);
        }
        finally {
            SearchContext.removeCurrent();
        }
    }

    private UpdateByQueryContext parseRequestSource(IndexService indexService, ShardUpdateByQueryRequest request, SearchContext context) {
        ParsedQuery parsedQuery = null;
        String script = null;
        String scriptFile = null;
        String scriptLang = null;
        Map params = Maps.newHashMap();
        try {
            XContentParser parser = XContentHelper.createParser((BytesReference)request.source());
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    if ("query".equals(fieldName)) {
                        parsedQuery = indexService.queryParserService().parse(parser);
                    } else if ("query_binary".equals(fieldName)) {
                        parser.nextToken();
                        byte[] querySource = parser.binaryValue();
                        XContentParser qSourceParser = XContentFactory.xContent((byte[])querySource).createParser(querySource);
                        parsedQuery = indexService.queryParserService().parse(qSourceParser);
                    } else if ("script".equals(fieldName)) {
                        parser.nextToken();
                        script = parser.text();
                    } else if ("script_file".equals(fieldName)) {
                        parser.nextToken();
                        scriptFile = parser.text();
                    } else if ("lang".equals(fieldName)) {
                        parser.nextToken();
                        scriptLang = parser.text();
                    } else if ("params".equals(fieldName)) {
                        parser.nextToken();
                        params = parser.map();
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException("Couldn't parse query from source.", (Throwable)e);
        }
        if (parsedQuery == null) {
            throw new ElasticsearchException("Query is required");
        }
        if (script == null && scriptFile == null) {
            throw new ElasticsearchException("Script or script_file is required");
        }
        context.parsedQuery(parsedQuery);
        return new UpdateByQueryContext(context, this.batchSize, this.clusterService.state(), script, scriptFile, scriptLang, params);
    }

    class TransportHandler
    extends BaseTransportRequestHandler<ShardUpdateByQueryRequest> {
        TransportHandler() {
        }

        public ShardUpdateByQueryRequest newInstance() {
            return new ShardUpdateByQueryRequest();
        }

        public String executor() {
            return "same";
        }

        public void messageReceived(ShardUpdateByQueryRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportShardUpdateByQueryAction.this.execute((ActionRequest)request, (ActionListener)new ActionListener<ShardUpdateByQueryResponse>(){

                public void onResponse(ShardUpdateByQueryResponse result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportShardUpdateByQueryAction.this.logger.warn("Failed to send response for get", (Throwable)e1, new Object[0]);
                    }
                }
            });
        }
    }

    class BatchedShardUpdateByQueryExecutor
    implements ActionListener<BulkShardResponse> {
        private final ActionListener<ShardUpdateByQueryResponse> finalResponseListener;
        private final DocIdSetIterator iterator;
        private final int matches;
        private final ShardUpdateByQueryRequest request;
        private final List<BulkItemResponse> receivedBulkItemResponses;
        private final UpdateByQueryContext updateByQueryContext;
        private int updated;

        BatchedShardUpdateByQueryExecutor(ActionListener<ShardUpdateByQueryResponse> finalResponseListener, FixedBitSet docsToUpdate, ShardUpdateByQueryRequest request, UpdateByQueryContext updateByQueryContext) {
            this.iterator = docsToUpdate.iterator();
            this.matches = docsToUpdate.cardinality();
            this.request = request;
            this.finalResponseListener = finalResponseListener;
            this.receivedBulkItemResponses = new ArrayList<BulkItemResponse>();
            this.updateByQueryContext = updateByQueryContext;
        }

        public synchronized void onResponse(BulkShardResponse bulkShardResponse) {
            try {
                block6: for (BulkItemResponse itemResponse : bulkShardResponse.getResponses()) {
                    if (!itemResponse.isFailed()) {
                        ++this.updated;
                    }
                    switch (this.request.bulkResponseOptions()) {
                        case ALL: {
                            this.receivedBulkItemResponses.add(itemResponse);
                            continue block6;
                        }
                        case FAILED: {
                            if (!itemResponse.isFailed()) continue block6;
                            this.receivedBulkItemResponses.add(itemResponse);
                            continue block6;
                        }
                    }
                }
                if (this.iterator.docID() == Integer.MAX_VALUE) {
                    this.finalizeBulkActions(null);
                } else {
                    TransportShardUpdateByQueryAction.this.threadPool.executor("bulk").execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BatchedShardUpdateByQueryExecutor.this.executeBulkIndex();
                            }
                            catch (Throwable e) {
                                BatchedShardUpdateByQueryExecutor.this.onFailure(e);
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.onFailure(t);
            }
        }

        public synchronized void onFailure(Throwable e) {
            try {
                TransportShardUpdateByQueryAction.this.logger.debug("error while executing bulk operations for an update by query action, sending partial response...", e, new Object[0]);
                this.finalizeBulkActions(e);
            }
            catch (Throwable t) {
                this.finalResponseListener.onFailure(t);
            }
        }

        public void executeBulkIndex() throws IOException {
            this.fillBatch(this.iterator, this.updateByQueryContext.searchContext.searcher().getIndexReader(), this.request, this.updateByQueryContext.bulkItemRequestsBulkList);
            TransportShardUpdateByQueryAction.this.logger.trace("[{}][{}] executing bulk request with size {}", new Object[]{this.request.index(), this.request.shardId(), this.updateByQueryContext.bulkItemRequestsBulkList.size()});
            if (this.updateByQueryContext.bulkItemRequestsBulkList.isEmpty()) {
                this.onResponse(new PublicBulkShardResponse(new ShardId(this.request.index(), this.request.shardId()), new BulkItemResponse[0]));
            } else {
                BulkItemRequest[] bulkItemRequests = this.updateByQueryContext.bulkItemRequestsBulkList.toArray(new BulkItemRequest[this.updateByQueryContext.bulkItemRequestsBulkList.size()]);
                this.updateByQueryContext.bulkItemRequestsBulkList.clear();
                BulkRequest fakeBulkRequest = new BulkRequest();
                PublicBulkShardRequest bulkShardRequest = new PublicBulkShardRequest(fakeBulkRequest, this.request.index(), this.request.shardId(), false, bulkItemRequests);
                bulkShardRequest.operationThreaded(false);
                TransportShardUpdateByQueryAction.this.bulkAction.execute((ActionRequest)bulkShardRequest, (ActionListener)this);
            }
        }

        private void finalizeBulkActions(Throwable e) {
            this.updateByQueryContext.searchContext.close();
            BulkItemResponse[] bulkResponses = this.receivedBulkItemResponses.toArray(new BulkItemResponse[this.receivedBulkItemResponses.size()]);
            this.receivedBulkItemResponses.clear();
            ShardUpdateByQueryResponse finalResponse = new ShardUpdateByQueryResponse(this.request.shardId(), this.matches, this.updated, bulkResponses);
            if (e != null) {
                finalResponse.failedShardExceptionMessage(ExceptionsHelper.detailedMessage((Throwable)e));
            }
            this.finalResponseListener.onResponse((Object)finalResponse);
        }

        private void fillBatch(DocIdSetIterator iterator, IndexReader indexReader, ShardUpdateByQueryRequest request, List<BulkItemRequest> bulkItemRequests) throws IOException {
            int counter = 0;
            int docID = iterator.nextDoc();
            while (docID != Integer.MAX_VALUE) {
                JustUidFieldsVisitor fieldVisitor = new JustUidFieldsVisitor();
                indexReader.document(docID, (StoredFieldVisitor)fieldVisitor);
                Uid uid = fieldVisitor.uid();
                UpdateRequest updateRequest = new UpdateRequest(request.index(), uid.type(), uid.id()).scriptLang(this.updateByQueryContext.scriptLang).scriptParams(this.updateByQueryContext.scriptParams);
                if (this.updateByQueryContext.scriptFileString != null) {
                    updateRequest.script(this.updateByQueryContext.scriptFileString, ScriptService.ScriptType.FILE);
                } else {
                    updateRequest.script(this.updateByQueryContext.scriptString);
                }
                bulkItemRequests.add(new BulkItemRequest(counter, (ActionRequest)updateRequest));
                if (++counter == TransportShardUpdateByQueryAction.this.batchSize) break;
                docID = iterator.nextDoc();
            }
        }
    }
}

