/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequest;
import org.elasticsearch.action.updatebyquery.BulkResponseOption;
import org.elasticsearch.action.updatebyquery.UpdateByQuerySourceBuilder;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;

public class UpdateByQueryRequest
extends IndicesReplicationOperationRequest<UpdateByQueryRequest> {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private String[] types = Strings.EMPTY_ARRAY;
    private BulkResponseOption bulkResponseOption = BulkResponseOption.NONE;
    private String routing;
    private BytesReference source;
    private boolean sourceUnsafe;
    long nowInMillis;

    UpdateByQueryRequest() {
    }

    public UpdateByQueryRequest(String[] indices, String[] types) {
        this.indices = indices;
        this.types = types;
    }

    public String[] types() {
        return this.types;
    }

    public UpdateByQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public UpdateByQueryRequest source(BytesReference source, boolean sourceUnsafe) {
        this.source = source;
        this.sourceUnsafe = sourceUnsafe;
        return this;
    }

    public UpdateByQueryRequest source(UpdateByQuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(contentType);
        this.sourceUnsafe = false;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public boolean sourceUnsafe() {
        return this.sourceUnsafe;
    }

    public BulkResponseOption bulkResponseOptions() {
        return this.bulkResponseOption;
    }

    public UpdateByQueryRequest bulkResponseOptions(BulkResponseOption bulkResponseOption) {
        this.bulkResponseOption = bulkResponseOption;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public UpdateByQueryRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public void beforeLocalFork() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.source == null) {
            validationException = ValidateActions.addValidationError((String)"Source is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.types = in.readStringArray();
        this.bulkResponseOption = BulkResponseOption.fromId(in.readByte());
        this.routing = in.readOptionalString();
        this.source = in.readBytesReference();
        this.sourceUnsafe = false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.types);
        out.writeByte(this.bulkResponseOption.id());
        out.writeOptionalString(this.routing);
        out.writeBytesReference(this.source);
    }
}

