/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.updatebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.action.updatebyquery.BulkResponseOption;
import org.elasticsearch.action.updatebyquery.IndexUpdateByQueryRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShardUpdateByQueryRequest
extends ShardReplicationOperationRequest {
    private String[] types;
    private BulkResponseOption bulkResponseOption;
    private String[] filteringAliases = Strings.EMPTY_ARRAY;
    private BytesReference source;
    private boolean sourceUnsafe;
    private long nowInMillis;
    private int shardId = -1;
    private String targetNodeId;

    ShardUpdateByQueryRequest() {
    }

    ShardUpdateByQueryRequest(IndexUpdateByQueryRequest request, int shardId, String targetNodeId) {
        this.index(request.index());
        this.replicationType(request.replicationType());
        this.consistencyLevel(request.consistencyLevel());
        this.timeout = request.timeout();
        this.listenerThreaded(request.listenerThreaded());
        this.types = request.types();
        this.source = request.source();
        this.sourceUnsafe = request.sourceUnsafe();
        this.bulkResponseOption = request.bulkResponseOptions();
        this.filteringAliases = request.filteringAliases();
        this.nowInMillis = request.nowInMillis();
        this.shardId = shardId;
        this.targetNodeId = targetNodeId;
    }

    public String[] types() {
        return this.types;
    }

    public BytesReference source() {
        return this.source;
    }

    public boolean sourceUnsafe() {
        return this.sourceUnsafe;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public int shardId() {
        return this.shardId;
    }

    public String targetNodeId() {
        return this.targetNodeId;
    }

    public BulkResponseOption bulkResponseOptions() {
        return this.bulkResponseOption;
    }

    public void beforeLocalFork() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.source == null) {
            validationException = ValidateActions.addValidationError((String)"Source is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.types = in.readStringArray();
        this.bulkResponseOption = BulkResponseOption.fromId(in.readByte());
        this.filteringAliases = in.readStringArray();
        this.shardId = in.readVInt();
        this.targetNodeId = in.readString();
        this.source = in.readBytesReference();
        this.sourceUnsafe = false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.types);
        out.writeByte(this.bulkResponseOption.id());
        out.writeStringArray(this.filteringAliases);
        out.writeVInt(this.shardId);
        out.writeString(this.targetNodeId);
        out.writeBytesReference(this.source);
    }
}

