/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.ftp;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.CommonAbstractFileSystem;
import tv.hd3g.transfertfiles.ftp.FTPFile;
import tv.hd3g.transfertfiles.ftp.FTPListing;

public class FTPFileSystem
extends CommonAbstractFileSystem<FTPFile> {
    private static final Logger log = LogManager.getLogger();
    protected final InetAddress host;
    protected final int port;
    protected final String username;
    private final char[] password;
    private final boolean passiveMode;
    private FTPListing ftpListing;
    private final FTPClient client;

    public FTPFileSystem(InetAddress host, int port, String username, char[] password, boolean passiveMode, String basePath) {
        super(basePath);
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.username = Objects.requireNonNull(username, "FTP username");
        if (username.length() == 0) {
            throw new IllegalArgumentException("Invalid (empty) username");
        }
        this.password = Optional.ofNullable(password).orElse(new char[0]);
        this.passiveMode = passiveMode;
        this.client = new FTPClient();
        log.debug("Init ftp client to {}", (Object)this);
    }

    public String toString() {
        return "ftp://" + this.username + "@" + this.host.getHostName() + ":" + this.port + this.getBasePath();
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    @Override
    public void connect() {
        if (this.isAvaliable()) {
            return;
        }
        FTPClient ftpClient = this.getClient();
        if (this.timeoutDuration > 0L) {
            this.client.setConnectTimeout((int)this.timeoutDuration);
            this.client.setControlKeepAliveReplyTimeout((int)this.timeoutDuration);
            this.client.setControlKeepAliveTimeout(this.timeoutDuration);
            this.client.setDefaultTimeout((int)this.timeoutDuration);
            this.client.setDataTimeout((int)this.timeoutDuration);
        }
        try {
            log.debug("Start to connect to {}", (Object)this);
            ftpClient.connect(this.host, this.port);
            log.trace("Login to {}", (Object)this);
            boolean loginOk = ftpClient.login(this.username, new String(this.password));
            if (!loginOk) {
                throw new IOException("Can't login to FTP server");
            }
            if (this.passiveMode) {
                log.debug("Switch to passive for {}", (Object)this);
                ftpClient.enterLocalPassiveMode();
                int replyCode = ftpClient.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                    throw new IOException("FTP error: " + replyCode);
                }
            }
            log.trace("Set binary connection to {}", (Object)this);
            boolean setToBin = ftpClient.setFileType(2);
            if (!setToBin) {
                throw new IOException("Can't switch to binary the FTP connection");
            }
            ftpClient.setListHiddenFiles(true);
        }
        catch (IOException e) {
            if (ftpClient.isConnected() || ftpClient.isAvailable()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException e1) {
                    log.error("Can't disconnect properly after login error", (Throwable)e1);
                }
            }
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isAvaliable() {
        return this.getClient().isAvailable();
    }

    @Override
    public void close() {
        try {
            FTPClient ftpClient = this.getClient();
            if (ftpClient.isConnected()) {
                log.info("Manually disconnect client for {}", (Object)this);
                ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public int getIOBufferSize() {
        FTPClient ftpClient = this.getClient();
        return IntStream.of(4096, ftpClient.getBufferSize(), ftpClient.getSendDataSocketBufferSize(), ftpClient.getReceiveDataSocketBufferSize()).max().getAsInt();
    }

    @Override
    public FTPFile getFromPath(String path) {
        if (!this.isAvaliable()) {
            throw new UncheckedIOException(new IOException("FTP client not connected"));
        }
        String aPath = this.getPathFromRelative(path);
        log.trace("Create new FTPFile to \"{}\" relative to \"{}\"", (Object)this, (Object)aPath);
        return new FTPFile(this, path, aPath);
    }

    public void setFtpListing(FTPListing ftpListing) {
        this.ftpListing = ftpListing;
    }

    public FTPListing getFtpListing() {
        return this.ftpListing;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.host, this.port, this.username);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FTPFileSystem other = (FTPFileSystem)obj;
        return Objects.equals(this.host, other.host) && this.port == other.port && Objects.equals(this.username, other.username);
    }

    @Override
    public int reusableHashCode() {
        return this.getClient().hashCode();
    }
}

