/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BufferVault {
    private byte[] datas;
    private int size;
    private boolean justWrite;

    public BufferVault() {
        this.datas = new byte[0];
        this.size = 0;
        this.justWrite = false;
    }

    public BufferVault(int baseInternalArraySize) {
        this.datas = new byte[baseInternalArraySize];
        this.size = 0;
        this.justWrite = false;
    }

    public synchronized BufferVault copy() {
        BufferVault buffer = new BufferVault(this.size);
        buffer.size = this.size;
        System.arraycopy(this.datas, 0, buffer.datas, 0, this.size);
        return buffer;
    }

    public static BufferVault wrap(byte[] byteArrayToHeapByteBuffer) {
        return new BufferVault().write(byteArrayToHeapByteBuffer);
    }

    private static void checkBufferArray(byte[] buffer, int pos, int len) {
        Objects.checkFromIndexSize(pos, len, buffer.length);
    }

    public synchronized BufferVault ensureBufferSize(int itemsCountToAdd) {
        int missingSize = this.size + itemsCountToAdd - this.datas.length;
        if (itemsCountToAdd < 0) {
            throw new IllegalArgumentException("Invalid itemsCountToAdd=" + itemsCountToAdd);
        }
        if (missingSize <= 0) {
            return this;
        }
        byte[] newData = new byte[this.datas.length + missingSize];
        System.arraycopy(this.datas, 0, newData, 0, this.size);
        this.datas = newData;
        this.justWrite = true;
        return this;
    }

    public synchronized void clear() {
        this.size = 0;
        this.justWrite = true;
    }

    public synchronized BufferVault write(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return this;
        }
        this.justWrite = true;
        int remaining = buffer.remaining();
        this.ensureBufferSize(remaining);
        buffer.get(this.datas, this.size, remaining);
        this.size += remaining;
        return this;
    }

    public synchronized BufferVault write(byte[] buffer, int pos, int len) {
        if (len == 0) {
            return this;
        }
        BufferVault.checkBufferArray(buffer, pos, len);
        this.justWrite = true;
        this.ensureBufferSize(len);
        System.arraycopy(buffer, pos, this.datas, this.size, len);
        this.size += len;
        return this;
    }

    public synchronized BufferVault write(byte[] buffer) {
        return this.write(buffer, 0, buffer.length);
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized byte[] readAll() {
        byte[] array = new byte[this.size];
        System.arraycopy(this.datas, 0, array, 0, this.size);
        return array;
    }

    public synchronized int read(byte[] b, int pos, int off, int len) {
        Objects.checkFromIndexSize(off, len, b.length);
        if (pos >= this.size) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int lenToRead = Math.min(len, this.size - pos);
        System.arraycopy(this.datas, pos, b, off, lenToRead);
        return lenToRead;
    }

    public synchronized int read(int pos) {
        if (pos >= this.size) {
            return -1;
        }
        if (pos < 0) {
            throw new IndexOutOfBoundsException("Can't access to negative positions: " + pos);
        }
        return this.datas[pos] & 0xFF;
    }

    public synchronized ByteBuffer readAllToByteBuffer() {
        return ByteBuffer.allocate(this.size).put(this.datas, 0, this.size).flip();
    }

    public synchronized Iterator<byte[]> iterator(int bufferSize) {
        this.justWrite = false;
        return new Itr(bufferSize);
    }

    public synchronized Stream<byte[]> stream(int bufferSize) {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(bufferSize), (long)this.size, 1360), false);
    }

    public OutputStream asOutputStream() {
        final BufferVault ref = this;
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                ref.write(new byte[]{(byte)b});
            }

            @Override
            public void write(byte[] b) throws IOException {
                ref.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ref.write(b, off, len);
            }
        };
    }

    public synchronized BufferVault read(OutputStream outStream) throws IOException {
        outStream.write(this.datas, 0, this.size);
        return this;
    }

    public synchronized int write(InputStream inStream, int bufferSize) throws IOException {
        int read;
        this.ensureBufferSize(inStream.available());
        int transferred = 0;
        byte[] buffer = new byte[bufferSize];
        while ((read = inStream.read(buffer, 0, buffer.length)) >= 0) {
            this.write(buffer, 0, read);
            transferred += read;
        }
        return transferred;
    }

    public synchronized int hashCode() {
        int result = 1;
        for (int pos = 0; pos < this.size; ++pos) {
            result = 31 * result + this.datas[pos];
        }
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BufferVault other = (BufferVault)obj;
        return Arrays.equals(this.datas, 0, this.size, other.datas, 0, other.size);
    }

    public synchronized void compactAndAppend(int pos, BufferVault inserted) {
        if (pos < 0) {
            throw new IllegalArgumentException("Invalid negative pos: " + pos);
        }
        this.justWrite = true;
        if (pos >= this.size) {
            this.clear();
            this.write(inserted.datas);
        } else if (this.datas.length == 0 || pos == 0) {
            this.write(inserted.datas);
        } else if (pos + inserted.size > this.datas.length) {
            byte[] datasLarger = new byte[this.size - pos + inserted.size];
            System.arraycopy(this.datas, pos, datasLarger, 0, this.size - pos);
            this.datas = datasLarger;
            System.arraycopy(inserted.datas, 0, this.datas, this.size - pos, inserted.size);
            this.size = this.datas.length;
        } else {
            byte[] newDatas = new byte[this.size - pos + inserted.size];
            System.arraycopy(this.datas, pos, newDatas, 0, this.size - pos);
            System.arraycopy(inserted.datas, 0, newDatas, this.size - pos, inserted.size);
            this.datas = newDatas;
            this.size = newDatas.length;
        }
    }

    private class Itr
    implements Iterator<byte[]> {
        private final byte[] bArray;
        private volatile int readIndex;

        Itr(int bufferSize) {
            this.bArray = new byte[bufferSize];
            this.readIndex = 0;
        }

        @Override
        public synchronized boolean hasNext() {
            if (BufferVault.this.justWrite) {
                throw new IllegalStateException("You can't iterate just after write. This instance is obsolete");
            }
            return this.readIndex + 1 <= BufferVault.this.size;
        }

        @Override
        public synchronized byte[] next() {
            if (BufferVault.this.justWrite) {
                throw new IllegalStateException("You can't iterate just after write. This instance is obsolete");
            }
            if (this.readIndex + 1 > BufferVault.this.size) {
                throw new NoSuchElementException();
            }
            byte[] array = BufferVault.this.size - this.readIndex < this.bArray.length ? new byte[BufferVault.this.size - this.readIndex] : this.bArray;
            System.arraycopy(BufferVault.this.datas, this.readIndex, array, 0, array.length);
            this.readIndex += array.length;
            return array;
        }
    }
}

