/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystem;
import tv.hd3g.transfertfiles.URLAccess;
import tv.hd3g.transfertfiles.ftp.FTPESFileSystem;
import tv.hd3g.transfertfiles.ftp.FTPFileSystem;
import tv.hd3g.transfertfiles.ftp.FTPSFileSystem;
import tv.hd3g.transfertfiles.local.LocalFileSystem;
import tv.hd3g.transfertfiles.sftp.SFTPFileSystem;

public class AbstractFileSystemURL
implements Closeable {
    private static final Logger log = LogManager.getLogger();
    private final String protectedRessourceURL;
    private final AbstractFileSystem<?> fileSystem;
    private final String basePath;

    protected AbstractFileSystemURL(String protectedRessourceURL, AbstractFileSystem<?> fileSystem, String basePath) {
        this.protectedRessourceURL = protectedRessourceURL;
        this.fileSystem = fileSystem;
        this.basePath = basePath;
    }

    public AbstractFileSystemURL(String ressourceURL) {
        URLAccess url = new URLAccess(ressourceURL);
        String protocol = Objects.requireNonNull(url.getProtocol());
        this.basePath = AbstractFile.normalizePath(Optional.ofNullable(url.getPath()).orElse("/"));
        InetAddress host = this.resolveHostname(url);
        Map<String, List<String>> query = Objects.requireNonNull(url.getOptionZone());
        String username = url.getUsername();
        this.protectedRessourceURL = url.getProtectedRessourceURL() + " [" + host.getHostAddress() + "]";
        char[] password = url.getPassword();
        int port = url.getPort();
        boolean passive = !query.containsKey("active");
        boolean ignoreInvalidCertificates = query.containsKey("ignoreInvalidCertificates");
        List<File> keys = query.getOrDefault("key", List.of()).stream().map(File::new).filter(File::exists).collect(Collectors.toUnmodifiableList());
        log.trace("Parsed URL: {}", Map.of("protocol", (Serializable)((Object)Optional.ofNullable(protocol).orElse("null")), "basePath", (Serializable)((Object)Optional.ofNullable(this.basePath).orElse("null")), "host", (Serializable)((Object)Optional.ofNullable(host).map(Object::toString).orElse("null")), "query", (Serializable)((Object)Optional.ofNullable(query).map(Object::toString).orElse("null")), "username", (Serializable)((Object)Optional.ofNullable(username).orElse("null")), "protectedRessourceURL", (Serializable)((Object)Optional.ofNullable(this.protectedRessourceURL).orElse("null")), "port", port, "passive", passive, "ignoreInvalidCertificates", ignoreInvalidCertificates, "keys", (Serializable)((Object)Optional.ofNullable(keys).map(Object::toString).orElse("null"))));
        if (protocol.contentEquals("file")) {
            log.debug("Init URL LocalFileSystem: {}", new Supplier[]{this::toString});
            this.fileSystem = new LocalFileSystem(new File(this.basePath));
        } else if (protocol.contentEquals("sftp")) {
            log.debug("Init URL SFTPFileSystem: {}", new Supplier[]{this::toString});
            this.fileSystem = new SFTPFileSystem(host, port, username, this.basePath);
            SFTPFileSystem sFTPfileSystem = (SFTPFileSystem)this.fileSystem;
            if (keys.isEmpty()) {
                if (password.length > 0) {
                    sFTPfileSystem.setPasswordAuth(password);
                }
            } else {
                keys.forEach(privateKey -> sFTPfileSystem.manuallyAddPrivatekeyAuth((File)privateKey, password));
            }
        } else if (protocol.contentEquals("ftp")) {
            log.debug("Init URL FTPFileSystem: {}", new Supplier[]{this::toString});
            this.fileSystem = new FTPFileSystem(host, port, username, password, passive, this.basePath);
        } else if (protocol.contentEquals("ftps")) {
            log.debug("Init URL FTPSFileSystem: {}", new Supplier[]{this::toString});
            this.fileSystem = new FTPSFileSystem(host, port, username, password, passive, ignoreInvalidCertificates, this.basePath);
        } else if (protocol.contentEquals("ftpes")) {
            log.debug("Init URL FTPESFileSystem: {}", new Supplier[]{this::toString});
            this.fileSystem = new FTPESFileSystem(host, port, username, password, passive, ignoreInvalidCertificates, this.basePath);
        } else {
            throw new UncheckedIOException(new IOException("Can't manage protocol \"" + protocol + "\" in URL: " + this.toString()));
        }
        Integer timeout = query.getOrDefault("timeout", List.of()).stream().map(Integer::valueOf).findFirst().orElse(0);
        if (timeout > 0) {
            this.fileSystem.setTimeout(timeout.intValue(), TimeUnit.SECONDS);
        }
    }

    private InetAddress resolveHostname(URLAccess url) {
        try {
            return InetAddress.getByName(Optional.ofNullable(url.getHost()).orElse("localhost"));
        }
        catch (UnknownHostException e) {
            throw new UncheckedIOException("Can't resolve hostname: \"" + url.getHost() + "\"", e);
        }
    }

    public String toString() {
        return this.protectedRessourceURL;
    }

    public AbstractFileSystem<?> getFileSystem() {
        return this.fileSystem;
    }

    public AbstractFile getFromPath(String path) {
        String p = AbstractFile.normalizePath(path);
        log.trace("Create new AbstractFile to \"{}\" with \"{}\"", (Object)p, this.fileSystem);
        this.fileSystem.connect();
        return this.fileSystem.getFromPath(p);
    }

    public AbstractFile getRootPath() {
        return this.getFromPath("");
    }

    @Override
    public void close() throws IOException {
        this.fileSystem.close();
    }

    public boolean isReusable() {
        return this.fileSystem.isReusable();
    }

    public String getBasePath() {
        return this.basePath;
    }
}

