/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.ftp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.ftp.StoppableIOStream;

public class StoppableInputStream
extends FilterInputStream
implements StoppableIOStream {
    private static final String NOT_IMPLEMENTED = "Not implemented";
    private static final Logger log = LogManager.getLogger();
    private volatile boolean stopped = false;

    public StoppableInputStream(InputStream in) {
        super(in);
    }

    @Override
    public synchronized void setStop() {
        log.debug("Stop InputStream");
        this.stopped = true;
    }

    @Override
    public int read() throws IOException {
        if (this.stopped) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.stopped) {
            return -1;
        }
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.stopped) {
            return -1;
        }
        return super.read(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        throw new IllegalArgumentException(NOT_IMPLEMENTED);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        throw new IllegalArgumentException(NOT_IMPLEMENTED);
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        throw new IllegalArgumentException(NOT_IMPLEMENTED);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.stopped) {
            return 0L;
        }
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.stopped) {
            return 0;
        }
        return super.available();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

