/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.ftp;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public enum FTPListing {
    NLST{

        @Override
        Stream<String> listDirectory(FTPClient ftpClient, String path) throws IOException {
            String[] rawList = Optional.ofNullable(ftpClient.listNames(path)).orElse(new String[0]);
            return Stream.of(rawList).filter(f -> !f.endsWith("."));
        }

        @Override
        Stream<FTPFile> rawListDirectory(FTPClient ftpClient, String path) throws IOException {
            throw new IllegalArgumentException("Not supported with NLST");
        }
    }
    ,
    LIST{

        @Override
        Stream<String> listDirectory(FTPClient ftpClient, String path) throws IOException {
            return this.rawListDirectory(ftpClient, path).map(FTPFile::getName);
        }

        @Override
        Stream<FTPFile> rawListDirectory(FTPClient ftpClient, String path) throws IOException {
            return FTPListing.rawFTPFileListToStream(ftpClient.listFiles(path));
        }
    }
    ,
    MLSD{

        @Override
        Stream<String> listDirectory(FTPClient ftpClient, String path) throws IOException {
            return this.rawListDirectory(ftpClient, path).map(FTPFile::getName);
        }

        @Override
        Stream<FTPFile> rawListDirectory(FTPClient ftpClient, String path) throws IOException {
            return FTPListing.rawFTPFileListToStream(ftpClient.mlistDir(path));
        }
    };


    private static Stream<FTPFile> rawFTPFileListToStream(FTPFile[] rawList) {
        FTPFile[] protectedList = Optional.ofNullable(rawList).orElse(new FTPFile[0]);
        return Stream.of(protectedList).filter(f -> !f.getName().endsWith("."));
    }

    abstract Stream<String> listDirectory(FTPClient var1, String var2) throws IOException;

    abstract Stream<FTPFile> rawListDirectory(FTPClient var1, String var2) throws IOException;
}

