/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.BufferVault;
import tv.hd3g.transfertfiles.filters.DataExchangeFilter;

public class DataExchangeInOutStream {
    private static final Logger log = LogManager.getLogger();
    private final InternalInputStream internalInputStream = new InternalInputStream();
    private final InternalOutputStream internalOutputStream = new InternalOutputStream();
    private final List<DataExchangeFilter> filters = Collections.synchronizedList(new ArrayList());
    private final ConcurrentLinkedQueue<ByteBuffer> readQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger ensureMinWriteBuffersSize;
    private final HashMap<DataExchangeFilter, Long> filterPerformance;
    private final HashMap<DataExchangeFilter, Long> filterDeltaThroughput;
    private final AtomicLong ioWaitTime;
    private volatile State state = State.WORKING;

    public DataExchangeInOutStream() {
        this.ensureMinWriteBuffersSize = new AtomicInteger();
        this.filterPerformance = new HashMap();
        this.filterDeltaThroughput = new HashMap();
        this.ioWaitTime = new AtomicLong(0L);
    }

    public synchronized TransfertStats getTransfertStats(DataExchangeFilter filter) {
        if (this.state == State.WORKING) {
            throw new IllegalStateException("Can't access to transfert stats during processing...");
        }
        return new TransfertStats(this.filterPerformance.computeIfAbsent(filter, f -> 0L), this.filterDeltaThroughput.computeIfAbsent(filter, f -> 0L));
    }

    public OutputStream getDestTargetStream() {
        return this.internalOutputStream;
    }

    public InputStream getSourceOriginStream() {
        return this.internalInputStream;
    }

    public synchronized void stop() {
        if (this.state == State.WORKING) {
            this.state = State.STOPPED_BY_USER;
        }
    }

    public long getIoWaitTime() {
        return this.ioWaitTime.get();
    }

    public synchronized State getState() {
        return this.state;
    }

    public DataExchangeInOutStream addFilter(DataExchangeFilter filter) {
        Objects.requireNonNull(filter);
        this.filters.add(filter);
        int buffersSize = this.ensureMinWriteBuffersSize.updateAndGet(current -> {
            int filterBuffer = filter.ensureMinDataSourcesDataLength();
            if (filterBuffer > current) {
                return filterBuffer;
            }
            return current;
        });
        int itemsCountToAdd = buffersSize - this.internalOutputStream.buffers.getSize();
        if (itemsCountToAdd > 0) {
            this.internalOutputStream.buffers.ensureBufferSize(itemsCountToAdd);
        }
        return this;
    }

    public class TransfertStats {
        private final long totalDuration;
        private final long deltaTranfered;

        private TransfertStats(long totalDuration, long deltaTranfered) {
            this.totalDuration = totalDuration;
            this.deltaTranfered = deltaTranfered;
        }

        public long getDeltaTranfered() {
            return this.deltaTranfered;
        }

        public long getTotalDuration() {
            return this.totalDuration;
        }
    }

    private class StoppedByFilter
    extends RuntimeException {
        StoppedByFilter(DataExchangeFilter filter) {
            super(filter.getFilterName());
        }
    }

    private class InternalOutputStream
    extends OutputStream {
        private final BufferVault buffers = new BufferVault();

        InternalOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Objects.checkFromIndexSize(off, len, b.length);
            if (len == 0) {
                throw new IllegalArgumentException("Invalid len=" + len);
            }
            if (DataExchangeInOutStream.this.state == State.WORKING) {
                while (!DataExchangeInOutStream.this.readQueue.isEmpty()) {
                    Thread.onSpinWait();
                }
                long now = System.currentTimeMillis();
                this.buffers.write(b, off, len);
                DataExchangeInOutStream.this.ioWaitTime.addAndGet(System.currentTimeMillis() - now);
                int totalWrited = this.buffers.getSize();
                log.trace("Write from b/off/len {}/{}/{} to total writed {}", (Object)b.length, (Object)off, (Object)len, (Object)totalWrited);
                if (totalWrited > DataExchangeInOutStream.this.ensureMinWriteBuffersSize.get()) {
                    this.processFilters(false);
                }
            }
            if (DataExchangeInOutStream.this.state == State.STOPPED_BY_FILTER) {
                throw new IOException("Stopped OutputStream (writer) by filter");
            }
            if (DataExchangeInOutStream.this.state == State.STOPPED_BY_USER) {
                throw new IOException("Stopped OutputStream (writer)");
            }
            if (DataExchangeInOutStream.this.state == State.WRITER_MANUALLY_CLOSED) {
                throw new IOException("Closed OutputStream (writer)");
            }
            if (DataExchangeInOutStream.this.state == State.FILTER_ERROR) {
                throw new IOException("Closed OutputStream (writer) caused by filter error");
            }
        }

        @Override
        public void write(int b) throws IOException {
            byte[] oneByte = new byte[]{(byte)b};
            this.write(oneByte, 0, 1);
        }

        @Override
        public void close() throws IOException {
            if (DataExchangeInOutStream.this.state.close) {
                return;
            }
            log.trace("Close write");
            this.processFilters(true);
            if (DataExchangeInOutStream.this.state == State.WORKING) {
                DataExchangeInOutStream.this.state = State.WRITER_MANUALLY_CLOSED;
            } else {
                if (DataExchangeInOutStream.this.state == State.STOPPED_BY_FILTER) {
                    throw new IOException("Stopped OutputStream (writer) by filter");
                }
                if (DataExchangeInOutStream.this.state == State.STOPPED_BY_USER) {
                    throw new IOException("Stopped OutputStream (writer)");
                }
                if (DataExchangeInOutStream.this.state == State.FILTER_ERROR) {
                    throw new IOException("Closed OutputStream (writer) caused by filter error");
                }
            }
        }

        private void processFilters(boolean lastCall) {
            boolean canceled = false;
            BufferVault nextBuffers = this.buffers;
            for (int posF = 0; posF < DataExchangeInOutStream.this.filters.size(); ++posF) {
                DataExchangeFilter currentFilter = DataExchangeInOutStream.this.filters.get(posF);
                if (canceled) {
                    try {
                        currentFilter.onCancelTransfert();
                    }
                    catch (Exception e) {
                        log.warn("Error during during close all filters", (Throwable)e);
                    }
                    continue;
                }
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("Apply filter {} for {} bytes...", (Object)currentFilter.getFilterName(), (Object)nextBuffers.getSize());
                    }
                    BufferVault previousBuffers = nextBuffers;
                    nextBuffers = this.applyFilter(lastCall, nextBuffers, currentFilter, previousBuffers);
                    continue;
                }
                catch (StoppedByFilter e) {
                    canceled = true;
                    log.info("Filter manually stop exchange process {}", (Object)currentFilter.getFilterName());
                    DataExchangeInOutStream.this.state = State.STOPPED_BY_FILTER;
                    continue;
                }
                catch (Exception e) {
                    canceled = true;
                    log.error("Error during process filtering (close exchange process)", (Throwable)e);
                    DataExchangeInOutStream.this.state = State.FILTER_ERROR;
                }
            }
            if (!canceled) {
                DataExchangeInOutStream.this.readQueue.add(nextBuffers.readAllToByteBuffer());
                if (log.isTraceEnabled()) {
                    log.trace("Filters: read queue has now {} item(s)", (Object)DataExchangeInOutStream.this.readQueue.size());
                }
                this.buffers.clear();
            }
        }

        private BufferVault applyFilter(boolean lastCall, BufferVault nextBuffers, DataExchangeFilter currentFilter, BufferVault previousBuffers) throws IOException {
            long currentPerformance = DataExchangeInOutStream.this.filterPerformance.computeIfAbsent(currentFilter, cF -> 0L);
            long currentDeltaThroughput = DataExchangeInOutStream.this.filterDeltaThroughput.computeIfAbsent(currentFilter, cF -> 0L);
            int inputBufferSize = nextBuffers.getSize();
            long now = System.currentTimeMillis();
            nextBuffers = currentFilter.applyDataFilter(lastCall, nextBuffers);
            currentPerformance += System.currentTimeMillis() - now;
            if (nextBuffers == null) {
                if (log.isTraceEnabled()) {
                    log.trace("After apply filter {}, want to stop!", (Object)currentFilter.getFilterName());
                }
                throw new StoppedByFilter(currentFilter);
            }
            DataExchangeInOutStream.this.filterPerformance.put(currentFilter, currentPerformance);
            DataExchangeInOutStream.this.filterDeltaThroughput.put(currentFilter, currentDeltaThroughput += (long)(inputBufferSize - nextBuffers.getSize()));
            if (nextBuffers.getSize() == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("After apply filter {}, no datas provided", (Object)currentFilter.getFilterName());
                }
                nextBuffers = previousBuffers;
            } else if (log.isTraceEnabled()) {
                log.trace("After apply filter {}, provide {} bytes", (Object)currentFilter.getFilterName(), (Object)nextBuffers.getSize());
            }
            return nextBuffers;
        }
    }

    private class InternalInputStream
    extends InputStream {
        private volatile boolean readerClosed = false;

        private InternalInputStream() {
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Objects.checkFromIndexSize(off, len, b.length);
            if (len == 0) {
                throw new IllegalArgumentException("Invalid len=" + len);
            }
            if (log.isTraceEnabled()) {
                log.trace("Read event (wait) of {} byte(s), {} in queue...", (Object)len, (Object)DataExchangeInOutStream.this.readQueue.size());
            }
            while (DataExchangeInOutStream.this.readQueue.isEmpty() && DataExchangeInOutStream.this.state == State.WORKING && !this.readerClosed) {
                Thread.onSpinWait();
            }
            if (this.readerClosed) {
                throw new IOException("Closed InputStream (reader)");
            }
            if (DataExchangeInOutStream.this.state.stopped) {
                log.trace("Read stopped: {}, {} in queue", (Object)DataExchangeInOutStream.this.state, (Object)DataExchangeInOutStream.this.readQueue.size());
                this.readerClosed = true;
                return -1;
            }
            if (DataExchangeInOutStream.this.readQueue.isEmpty() && DataExchangeInOutStream.this.state.close) {
                log.trace("Read: outstream (reader) was close, nothing in queue");
                return -1;
            }
            ByteBuffer buffer = (ByteBuffer)DataExchangeInOutStream.this.readQueue.element();
            int toRead = Math.min(buffer.remaining(), len);
            log.trace("Read from remaining={} toRead={} to b={} off={} len={}", (Object)buffer.remaining(), (Object)toRead, (Object)b.length, (Object)off, (Object)len);
            long now = System.currentTimeMillis();
            buffer.get(b, off, toRead);
            DataExchangeInOutStream.this.ioWaitTime.addAndGet(System.currentTimeMillis() - now);
            if (!buffer.hasRemaining()) {
                DataExchangeInOutStream.this.readQueue.remove();
            }
            return toRead;
        }

        @Override
        public int read() throws IOException {
            byte[] oneByte = new byte[1];
            int size = this.read(oneByte, 0, 1);
            if (size == 1) {
                return oneByte[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public int available() throws IOException {
            if (this.readerClosed || DataExchangeInOutStream.this.state.stopped) {
                return 0;
            }
            return (int)DataExchangeInOutStream.this.readQueue.stream().mapToInt(Buffer::remaining).summaryStatistics().getSum();
        }

        @Override
        public void close() throws IOException {
            if (this.readerClosed) {
                return;
            }
            this.readerClosed = true;
            DataExchangeInOutStream.this.internalOutputStream.close();
            DataExchangeInOutStream.this.readQueue.forEach(ByteBuffer::clear);
            log.trace("Close read");
        }
    }

    public static enum State {
        WORKING(false, false),
        STOPPED_BY_USER(true, false),
        STOPPED_BY_FILTER(true, false),
        WRITER_MANUALLY_CLOSED(false, true),
        FILTER_ERROR(false, true);

        final boolean stopped;
        final boolean close;

        private State(boolean stopped, boolean close) {
            this.stopped = stopped;
            this.close = close;
        }
    }
}

