/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.sftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPFileTransfer;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystem;
import tv.hd3g.transfertfiles.CachedFileAttributes;
import tv.hd3g.transfertfiles.CannotDeleteException;
import tv.hd3g.transfertfiles.CommonAbstractFile;
import tv.hd3g.transfertfiles.SizedStoppableCopyCallback;
import tv.hd3g.transfertfiles.TransfertObserver;
import tv.hd3g.transfertfiles.sftp.SFTPFileSystem;

public class SFTPFile
extends CommonAbstractFile<SFTPFileSystem> {
    private static final Logger log = LoggerFactory.getLogger(SFTPFile.class);
    private static final String CAN_T_STAT = "Can't stat \"";
    private final SFTPClient sftpClient;
    private final String sftpAbsolutePath;
    private final UnaryOperator<String> toRelativePath = ftpClientAbsolutePath -> {
        if (((SFTPFileSystem)this.fileSystem).isAbsoluteBasePath()) {
            return AbstractFile.normalizePath(ftpClientAbsolutePath.substring(((SFTPFileSystem)this.fileSystem).getBasePath().length()));
        }
        return AbstractFile.normalizePath(ftpClientAbsolutePath.substring(((SFTPFileSystem)this.fileSystem).getBasePath().length() - 1));
    };

    SFTPFile(SFTPFileSystem fileSystem, SFTPClient sftpClient, String relativePath, String absolutePath) {
        super(fileSystem, relativePath);
        this.sftpAbsolutePath = fileSystem.isAbsoluteBasePath() ? absolutePath : (!absolutePath.isEmpty() ? absolutePath.substring(1) : "");
        this.sftpClient = sftpClient;
    }

    private boolean isNoSuchFileInError(IOException e) {
        return e.getMessage().toUpperCase().startsWith("No such file".toUpperCase());
    }

    @Override
    public AbstractFileSystem<?> getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public long length() {
        try {
            return this.sftpClient.size(this.sftpAbsolutePath);
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e)) {
                return 0L;
            }
            throw new UncheckedIOException("Can't extract size \"" + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public boolean exists() {
        try {
            return this.sftpClient.statExistence(this.sftpAbsolutePath) != null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(CAN_T_STAT + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public void delete() {
        boolean directory = this.isDirectory();
        try {
            if (directory) {
                this.sftpClient.rmdir(this.sftpAbsolutePath);
            } else {
                this.sftpClient.rm(this.sftpAbsolutePath);
            }
        }
        catch (IOException e) {
            throw new CannotDeleteException(this, directory, e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.sftpClient.stat(this.sftpAbsolutePath).getType() == FileMode.Type.DIRECTORY;
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e)) {
                return false;
            }
            throw new UncheckedIOException(CAN_T_STAT + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.sftpClient.stat(this.sftpAbsolutePath).getType() == FileMode.Type.REGULAR;
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e)) {
                return false;
            }
            throw new UncheckedIOException(CAN_T_STAT + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public boolean isLink() {
        try {
            return this.sftpClient.stat(this.sftpAbsolutePath).getType() == FileMode.Type.SYMLINK;
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e)) {
                return false;
            }
            throw new UncheckedIOException(CAN_T_STAT + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public boolean isSpecial() {
        try {
            FileMode.Type type = this.sftpClient.stat(this.sftpAbsolutePath).getType();
            return type != FileMode.Type.REGULAR && type != FileMode.Type.DIRECTORY && type != FileMode.Type.SYMLINK;
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e)) {
                return false;
            }
            throw new UncheckedIOException(CAN_T_STAT + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.sftpClient.stat(this.sftpAbsolutePath).getMtime() * 1000L;
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e)) {
                return 0L;
            }
            throw new UncheckedIOException(CAN_T_STAT + this.sftpAbsolutePath + "\"", e);
        }
    }

    private CachedFileAttributes makeCachedFileAttributesFromStat(AbstractFile related, FileAttributes f) {
        return new CachedFileAttributes(related, f.getSize(), f.getMtime() * 1000L, true, f.getType() == FileMode.Type.DIRECTORY, f.getType() == FileMode.Type.REGULAR, f.getType() == FileMode.Type.SYMLINK, f.getType() != FileMode.Type.REGULAR && f.getType() != FileMode.Type.DIRECTORY && f.getType() != FileMode.Type.SYMLINK);
    }

    @Override
    public CachedFileAttributes toCache() {
        try {
            return this.makeCachedFileAttributesFromStat(this, this.sftpClient.stat(this.sftpAbsolutePath));
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e)) {
                return CachedFileAttributes.notExists(this);
            }
            throw new UncheckedIOException(CAN_T_STAT + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public Stream<AbstractFile> list() {
        try {
            return this.sftpClient.ls(this.sftpAbsolutePath).stream().map(RemoteResourceInfo::getPath).map(this.toRelativePath).map(((SFTPFileSystem)this.fileSystem)::getFromPath);
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e) || e.getMessage().equals("Accessed location is not a directory")) {
                return Stream.empty();
            }
            throw new UncheckedIOException("Can't list \"" + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public Stream<CachedFileAttributes> toCachedList() {
        try {
            return this.sftpClient.ls(this.sftpAbsolutePath).stream().map(rri -> this.makeCachedFileAttributesFromStat(((SFTPFileSystem)this.fileSystem).getFromPath((String)this.toRelativePath.apply(rri.getPath())), rri.getAttributes()));
        }
        catch (IOException e) {
            if (this.isNoSuchFileInError(e) || e.getMessage().equals("Accessed location is not a directory")) {
                return Stream.empty();
            }
            throw new UncheckedIOException("Can't list \"" + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public void mkdir() {
        try {
            this.sftpClient.mkdirs(this.sftpAbsolutePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't mkdir(s) \"" + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public void mkdirs() {
        this.mkdir();
    }

    @Override
    public AbstractFile renameTo(String path) {
        try {
            String newPath = AbstractFile.normalizePath(path);
            if (((SFTPFileSystem)this.fileSystem).isAbsoluteBasePath()) {
                this.sftpClient.rename(this.sftpAbsolutePath, newPath);
            } else {
                this.sftpClient.rename(this.sftpAbsolutePath, newPath.substring(1));
            }
            return ((SFTPFileSystem)this.fileSystem).getFromPath(newPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't rename \"" + this.sftpAbsolutePath + "\"", e);
        }
    }

    @Override
    public void copyAbstractToLocal(File localFile, TransfertObserver observer) {
        this.copy(this.sftpAbsolutePath, localFile.getPath(), localFile, observer, TransfertObserver.TransfertDirection.DISTANTTOLOCAL);
    }

    @Override
    public void sendLocalToAbstract(File localFile, TransfertObserver observer) {
        this.copy(localFile.getPath(), this.sftpAbsolutePath, localFile, observer, TransfertObserver.TransfertDirection.LOCALTODISTANT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String source, String dest, final File localFile, final TransfertObserver observer, final TransfertObserver.TransfertDirection transfertDirection) {
        long sizeToTransfert = 0L;
        try {
            SFTPClient sFTPClient = this.sftpClient;
            synchronized (sFTPClient) {
                final SFTPFile thisRef = this;
                final long now = System.currentTimeMillis();
                SFTPFileTransfer ft = this.sftpClient.getFileTransfer();
                ft.setTransferListener(new TransferListener(){

                    public StreamCopier.Listener file(String name, long size) {
                        return transferred -> {
                            if (!observer.onTransfertProgress(localFile, thisRef, transfertDirection, now, transferred)) {
                                throw new StoppedTransfertException(localFile.getPath(), transferred);
                            }
                        };
                    }

                    public TransferListener directory(String name) {
                        return this;
                    }
                });
                observer.beforeTransfert(localFile, this, transfertDirection);
                if (transfertDirection == TransfertObserver.TransfertDirection.DISTANTTOLOCAL) {
                    if (this.sftpClient.stat(this.sftpAbsolutePath).getType() == FileMode.Type.DIRECTORY) {
                        throw new UncheckedIOException(new IOException("Source file is a directory, can't copy from it"));
                    }
                    sizeToTransfert = this.sftpClient.size(this.sftpAbsolutePath);
                    log.info("Download file from SSH host \"{}@{}:{}\" to \"{}\" ({} bytes)", new Object[]{((SFTPFileSystem)this.fileSystem).getUsername(), ((SFTPFileSystem)this.fileSystem).getHost(), source, dest, sizeToTransfert});
                    ft.download(source, dest);
                } else if (transfertDirection == TransfertObserver.TransfertDirection.LOCALTODISTANT) {
                    sizeToTransfert = localFile.length();
                    log.info("Upload file \"{}\" ({} bytes) to SSH host \"{}@{}:{}\"", new Object[]{localFile, sizeToTransfert, ((SFTPFileSystem)this.fileSystem).getUsername(), ((SFTPFileSystem)this.fileSystem).getHost(), dest});
                    ft.upload(source, dest);
                }
                observer.afterTransfert(localFile, this, transfertDirection, Duration.of(System.currentTimeMillis() - now, ChronoUnit.MILLIS));
            }
        }
        catch (StoppedTransfertException e) {
            log.info("Stop copy SSH file from \"{}\" to \"{}\", ({}/{} bytes)", new Object[]{source, dest, e.transferred, sizeToTransfert});
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't copy \"" + this.sftpAbsolutePath + "\"", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long downloadAbstract(OutputStream outputStream, int bufferSize, SizedStoppableCopyCallback copyCallback) {
        LocalDestFileImpl dest = new LocalDestFileImpl(outputStream, copyCallback);
        SFTPClient sFTPClient = this.sftpClient;
        synchronized (sFTPClient) {
            try {
                this.sftpClient.getFileTransfer().setTransferListener((TransferListener)dest);
                this.sftpClient.get(this.sftpAbsolutePath, (LocalDestFile)dest);
            }
            catch (StoppedTransfertException e) {
                log.debug("Manually stop ssh download", (Throwable)e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't download from \"" + this.sftpAbsolutePath + "\"", e);
            }
            finally {
                this.sftpClient.getFileTransfer().setTransferListener(null);
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("Can't close provided outputStream after use", (Throwable)e);
                }
            }
        }
        return dest.getTotalSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long uploadAbstract(InputStream inputStream, int bufferSize, SizedStoppableCopyCallback copyCallback) {
        LocalSourceFileImpl source = new LocalSourceFileImpl(this.getName(), inputStream, copyCallback);
        SFTPClient sFTPClient = this.sftpClient;
        synchronized (sFTPClient) {
            try {
                this.sftpClient.getFileTransfer().setTransferListener((TransferListener)source);
                this.sftpClient.put((LocalSourceFile)source, this.sftpAbsolutePath);
            }
            catch (StoppedTransfertException e) {
                log.debug("Manually stop ssh upload", (Throwable)e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't upload from \"" + this.sftpAbsolutePath + "\"", e);
            }
            finally {
                this.sftpClient.getFileTransfer().setTransferListener(null);
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("Can't close provided inputStream after use", (Throwable)e);
                }
            }
        }
        return source.getTotalSize();
    }

    private class StoppedTransfertException
    extends IOException {
        private final long transferred;

        public StoppedTransfertException(String source, long transferred) {
            super("Observer has stopped the transfert of " + source);
            this.transferred = transferred;
        }
    }

    private class LocalDestFileImpl
    extends TransferListenerImpl
    implements LocalDestFile {
        private final OutputStream outputStream;

        LocalDestFileImpl(OutputStream outputStream, SizedStoppableCopyCallback copyCallback) {
            super(copyCallback);
            this.outputStream = outputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.outputStream;
        }

        public LocalDestFile getChild(String name) {
            throw new UnsupportedOperationException("Not avaliable");
        }

        public LocalDestFile getTargetFile(String filename) throws IOException {
            return this;
        }

        public LocalDestFile getTargetDirectory(String dirname) throws IOException {
            throw new UnsupportedOperationException("Not avaliable");
        }

        public void setPermissions(int perms) throws IOException {
        }

        public void setLastAccessedTime(long t) throws IOException {
        }

        public void setLastModifiedTime(long t) throws IOException {
        }
    }

    private class LocalSourceFileImpl
    extends TransferListenerImpl
    implements LocalSourceFile {
        private final String name;
        private final InputStream inputStream;

        LocalSourceFileImpl(String name, InputStream inputStream, SizedStoppableCopyCallback copyCallback) {
            super(copyCallback);
            this.name = name;
            this.inputStream = inputStream;
        }

        public String getName() {
            return this.name;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public long getLength() {
            return -1L;
        }

        public int getPermissions() throws IOException {
            return 777;
        }

        public boolean isFile() {
            return true;
        }

        public boolean isDirectory() {
            return false;
        }

        public Iterable<? extends LocalSourceFile> getChildren(LocalFileFilter filter) throws IOException {
            return List.of();
        }

        public boolean providesAtimeMtime() {
            return false;
        }

        public long getLastAccessTime() throws IOException {
            return System.currentTimeMillis() / 1000L;
        }

        public long getLastModifiedTime() throws IOException {
            return System.currentTimeMillis() / 1000L;
        }
    }

    private class TransferListenerImpl
    implements TransferListener {
        private final SizedStoppableCopyCallback copyCallback;
        private final AtomicLong totalSize;

        TransferListenerImpl(SizedStoppableCopyCallback copyCallback) {
            this.copyCallback = copyCallback;
            this.totalSize = new AtomicLong();
        }

        public StreamCopier.Listener file(String name, long size) {
            return transferred -> {
                this.totalSize.set(transferred);
                if (((Boolean)this.copyCallback.apply(transferred)).equals(false)) {
                    throw new StoppedTransfertException(name, transferred);
                }
            };
        }

        public TransferListener directory(String name) {
            return this;
        }

        public long getTotalSize() {
            return this.totalSize.get();
        }
    }
}

