/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.sftp;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.Key;
import java.security.PublicKey;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultKnownHostsVerifier
extends OpenSSHKnownHosts {
    private static final Logger currentlog = LoggerFactory.getLogger(DefaultKnownHostsVerifier.class);

    public DefaultKnownHostsVerifier(File khFile) throws IOException {
        super(khFile);
        currentlog.debug("Set SSH known hosts file : \"{}\"", (Object)this.getFile().getAbsolutePath());
    }

    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        KeyType type = KeyType.fromKey((Key)key);
        currentlog.info("The authenticity of host '{}' can't be established. {} key fingerprint is {}.", new Object[]{hostname, type, SecurityUtils.getFingerprint((PublicKey)key)});
        try {
            this.entries().add(new OpenSSHKnownHosts.HostEntry(null, hostname, KeyType.fromKey((Key)key), key));
            this.write();
            currentlog.info("SSH: Permanently added '{}' ({}) to the list of known hosts.", (Object)hostname, (Object)type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }

    protected boolean hostKeyChangedAction(String hostname, PublicKey key) {
        KeyType type = KeyType.fromKey((Key)key);
        String fp = SecurityUtils.getFingerprint((PublicKey)key);
        String path = this.getFile().getAbsolutePath();
        currentlog.error("REMOTE HOST IDENTIFICATION HAS CHANGED! IT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY! Someone could be eavesdropping on you right now (man-in-the-middle attack)! It is also possible that the host key has just been changed. The fingerprint for the {} key sent by the remote host is {}. Please contact your system administrator or add correct host key in {} to get rid of this message.", new Object[]{type, fp, path});
        return false;
    }
}

