/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.local;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.CannotDeleteException;
import tv.hd3g.transfertfiles.CommonAbstractFile;
import tv.hd3g.transfertfiles.SizedStoppableCopyCallback;
import tv.hd3g.transfertfiles.TransfertObserver;
import tv.hd3g.transfertfiles.local.LocalFileSystem;

public class LocalFile
extends CommonAbstractFile<LocalFileSystem> {
    private static final Logger log = LoggerFactory.getLogger(LocalFile.class);
    private final File internalFile;

    private static String makePath(LocalFileSystem fileSystem, File internalFile) {
        int size = fileSystem.getRelativePath().getPath().length();
        return internalFile.getPath().substring(size).replace('\\', '/');
    }

    LocalFile(File internalFile, LocalFileSystem fileSystem) {
        super(fileSystem, LocalFile.makePath(fileSystem, internalFile));
        this.internalFile = internalFile;
    }

    public File getInternalFile() {
        return this.internalFile;
    }

    @Override
    public void copyAbstractToLocal(File localFile, TransfertObserver observer) {
        this.copy(this.internalFile, localFile, localFile, observer, TransfertObserver.TransfertDirection.DISTANTTOLOCAL);
    }

    @Override
    public void sendLocalToAbstract(File localFile, TransfertObserver observer) {
        this.copy(localFile, this.internalFile, localFile, observer, TransfertObserver.TransfertDirection.LOCALTODISTANT);
    }

    private void copy(File source, File fileDirDest, File localFile, TransfertObserver observer, TransfertObserver.TransfertDirection transfertDirection) {
        if (source.isDirectory()) {
            throw new UncheckedIOException(new IOException("Can't copy directories directly"));
        }
        File dest = fileDirDest.isDirectory() ? new File(fileDirDest, source.getName()) : fileDirDest;
        long now = System.currentTimeMillis();
        observer.beforeTransfert(localFile, this, transfertDirection);
        log.info("Copy local file from \"{}\" to \"{}\" ({} bytes)", new Object[]{source, dest, source.length()});
        boolean stopped = false;
        ByteBuffer buffer = ByteBuffer.allocateDirect(((LocalFileSystem)this.fileSystem).getIOBufferSize());
        try (SeekableByteChannel reader = Files.newByteChannel(source.toPath(), StandardOpenOption.READ);
             SeekableByteChannel writer = Files.newByteChannel(dest.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            long dataTransferred = 0L;
            while (reader.read(buffer) >= 0 || buffer.position() != 0) {
                buffer.flip();
                dataTransferred += (long)buffer.remaining();
                writer.write(buffer);
                buffer.compact();
                if (log.isTraceEnabled()) {
                    log.trace("Copy local progression from \"{}\" ({} bytes) to \"{}\": {} bytes", new Object[]{source, source.length(), dest, dataTransferred});
                }
                if (!(stopped = !observer.onTransfertProgress(localFile, this, transfertDirection, now, dataTransferred))) continue;
                log.info("Stop copy local file from \"{}\" ({} bytes) to \"{}\": {} bytes", new Object[]{source, source.length(), dest, dataTransferred});
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't copy \"" + source + "\"", e);
        }
        if (stopped) {
            return;
        }
        observer.afterTransfert(localFile, this, transfertDirection, Duration.of(System.currentTimeMillis() - now, ChronoUnit.MILLIS));
    }

    @Override
    public long downloadAbstract(OutputStream outputStream, int bufferSize, SizedStoppableCopyCallback copyCallback) {
        try {
            long l;
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.internalFile), bufferSize);
            try {
                l = LocalFile.observableCopyStream(inputStream, outputStream, bufferSize, copyCallback);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Can't download to \"" + this.internalFile + "\"", e);
                }
            }
            inputStream.close();
            return l;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error("Can't close provided outputStream after use", (Throwable)e);
            }
        }
    }

    @Override
    public long uploadAbstract(InputStream inputStream, int bufferSize, SizedStoppableCopyCallback copyCallback) {
        try {
            long l;
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.internalFile), bufferSize);
            try {
                l = LocalFile.observableCopyStream(inputStream, outputStream, bufferSize, copyCallback);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Can't upload from \"" + this.internalFile + "\"", e);
                }
            }
            outputStream.close();
            return l;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("Can't close provided inputStream after use", (Throwable)e);
            }
        }
    }

    @Override
    public long length() {
        return this.internalFile.length();
    }

    @Override
    public boolean exists() {
        return this.internalFile.exists();
    }

    @Override
    public void delete() {
        log.debug("Delete local file \"{}\"", (Object)this.internalFile);
        try {
            Files.delete(this.internalFile.toPath());
        }
        catch (IOException e) {
            if (this.isDirectory()) {
                throw new CannotDeleteException(this, true, new IOException("Can't delete directory: " + e.getMessage()));
            }
            throw new CannotDeleteException(this, false, new IOException("Can't delete file: " + e.getMessage()));
        }
    }

    @Override
    public boolean isDirectory() {
        return this.internalFile.isDirectory() && this.internalFile.canRead();
    }

    @Override
    public boolean isFile() {
        return this.internalFile.isFile() && this.internalFile.canRead();
    }

    @Override
    public boolean isLink() {
        return FileUtils.isSymlink((File)this.internalFile) && this.internalFile.canRead();
    }

    @Override
    public boolean isSpecial() {
        if (!this.internalFile.exists()) {
            return false;
        }
        try {
            return Optional.ofNullable(Files.readAttributes(this.internalFile.toPath(), BasicFileAttributes.class, new LinkOption[0])).map(BasicFileAttributes::isOther).orElse(false);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't extract attributes from \"" + this.internalFile + "\"", e);
        }
    }

    @Override
    public boolean isHidden() {
        return this.internalFile.isHidden() || super.isHidden();
    }

    @Override
    public long lastModified() {
        return this.internalFile.lastModified();
    }

    @Override
    public Stream<AbstractFile> list() {
        int rootLen = ((LocalFileSystem)this.fileSystem).getRelativePath().getPath().length();
        return Optional.ofNullable(this.internalFile.listFiles()).stream().flatMap(Stream::of).map(f -> ((LocalFileSystem)this.fileSystem).getFromPath(f.getPath().substring(rootLen)));
    }

    @Override
    public void mkdir() {
        log.debug("Mkdir local file \"{}\"", (Object)this.internalFile);
        try {
            FileUtils.forceMkdir((File)this.internalFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't mkdir \"" + this.internalFile + "\"", e);
        }
    }

    @Override
    public void mkdirs() {
        this.mkdir();
    }

    @Override
    public AbstractFile renameTo(String path) {
        if (!this.exists()) {
            throw new UncheckedIOException(new IOException("Can't move non-existent file/dir \"" + this.internalFile + "\""));
        }
        LocalFile newRef = ((LocalFileSystem)this.fileSystem).getFromPath(path);
        File dest = newRef.internalFile;
        log.debug("Rename local file \"{}\" to \"{}\", as \"{}\"", new Object[]{this.internalFile, dest, path});
        if (!this.internalFile.renameTo(dest)) {
            throw new UncheckedIOException(new IOException("Can't move \"" + this.internalFile + "\" to \"" + dest + "\""));
        }
        return newRef;
    }
}

