/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.ftp;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.transfertfiles.ftp.StoppableIOStream;

public class StoppableOutputStream
extends FilterOutputStream
implements StoppableIOStream {
    private static final Logger log = LoggerFactory.getLogger(StoppableOutputStream.class);
    static final String MANUALLY_STOP_WRITING = "Manually stop writing";
    private volatile boolean stopped = false;

    public StoppableOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void setStop() {
        log.debug("Stop OutputStream");
        this.stopped = true;
    }

    private void checkStop() throws IOException {
        if (this.stopped) {
            super.close();
            throw new IOException(MANUALLY_STOP_WRITING);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkStop();
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkStop();
        super.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkStop();
        super.write(b);
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

