/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.ftp;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.transfertfiles.CommonAbstractFileSystem;
import tv.hd3g.transfertfiles.InvalidURLException;
import tv.hd3g.transfertfiles.ftp.FTPFile;
import tv.hd3g.transfertfiles.ftp.FTPListing;

public class FTPFileSystem
extends CommonAbstractFileSystem<FTPFile> {
    private static final Logger log = LoggerFactory.getLogger(FTPFileSystem.class);
    protected final InetAddress host;
    protected final int port;
    protected final String username;
    private final char[] password;
    private final boolean passiveMode;
    private FTPListing ftpListing;
    private final FTPClient client;

    public FTPFileSystem(InetAddress host, int port, String username, char[] password, boolean passiveMode, String basePath) {
        super(basePath, username + "@" + host.getHostName() + ":" + port);
        this.host = InvalidURLException.requireNonNull(host, "Missing FTP host name");
        this.port = port;
        this.username = InvalidURLException.requireNonNull(username, "Missing FTP username");
        if (username.length() == 0) {
            throw new InvalidURLException("Invalid (empty) username");
        }
        this.password = Optional.ofNullable(password).orElse(new char[0]);
        this.passiveMode = passiveMode;
        this.client = new FTPClient();
        log.debug("Init ftp client to {}", (Object)this);
    }

    public String toString() {
        return "ftp://" + this.username + "@" + this.host.getHostName() + ":" + this.port + this.getBasePath();
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    protected void afterLogin() throws IOException {
    }

    @Override
    public void connect() {
        if (this.isAvaliable()) {
            return;
        }
        FTPClient ftpClient = this.getClient();
        if (this.timeoutDuration > 0L) {
            this.client.setConnectTimeout((int)this.timeoutDuration);
            this.client.setDefaultTimeout((int)this.timeoutDuration);
        }
        try {
            log.debug("Start to connect to {}", (Object)this);
            ftpClient.connect(this.host, this.port);
            log.trace("Login to {}", (Object)this);
            boolean loginOk = ftpClient.login(this.username, new String(this.password));
            if (!loginOk) {
                throw new IOException("Can't login to FTP server");
            }
            this.afterLogin();
            if (this.passiveMode) {
                log.debug("Switch to passive for {}", (Object)this);
                ftpClient.enterLocalPassiveMode();
                FTPFileSystem.checkIsPositiveCompletion(ftpClient.getReplyCode());
            }
            log.trace("Set binary connection to {}", (Object)this);
            boolean setToBin = ftpClient.setFileType(2);
            if (!setToBin) {
                throw new IOException("Can't switch to binary the FTP connection");
            }
            ftpClient.setListHiddenFiles(true);
        }
        catch (IOException e) {
            if (ftpClient.isConnected() || ftpClient.isAvailable()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException e1) {
                    log.error("Can't disconnect properly after login error", (Throwable)e1);
                }
            }
            throw new UncheckedIOException("Can't connect to FTP server " + this, e);
        }
    }

    protected static void checkIsPositiveCompletion(int replyCode) throws IOException {
        if (FTPReply.isPositiveCompletion((int)replyCode)) {
            return;
        }
        throw new IOException("FTP error: " + replyCode);
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isAvaliable() {
        return this.getClient().isAvailable();
    }

    @Override
    public void close() {
        try {
            FTPClient ftpClient = this.getClient();
            if (ftpClient.isConnected()) {
                log.info("Manually disconnect client for {}", (Object)this);
                ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't disconnect from FTP server " + this, e);
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public int getIOBufferSize() {
        FTPClient ftpClient = this.getClient();
        return IntStream.of(4096, ftpClient.getBufferSize(), ftpClient.getSendDataSocketBufferSize(), ftpClient.getReceiveDataSocketBufferSize()).max().getAsInt();
    }

    @Override
    public FTPFile getFromPath(String path) {
        if (!this.isAvaliable()) {
            throw new UncheckedIOException("The FTP client is not connected", new IOException());
        }
        String aPath = this.getPathFromRelative(path);
        log.trace("Create new FTPFile to \"{}\" relative to \"{}\"", (Object)this, (Object)aPath);
        return new FTPFile(this, path, aPath);
    }

    public void setFtpListing(FTPListing ftpListing) {
        this.ftpListing = ftpListing;
    }

    public FTPListing getFtpListing() {
        return this.ftpListing;
    }

    @Override
    public int reusableHashCode() {
        return this.getClient().hashCode();
    }
}

