/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.transfertfiles.AbstractFile;

public interface DataExchangeObserver {
    default public boolean onTransfertProgressFromSource(AbstractFile source, long startDate, long dataTransferred) {
        return true;
    }

    default public boolean onTransfertProgressToDestination(AbstractFile destination, long startDate, long dataTransferred) {
        return true;
    }

    default public void beforeTransfert(AbstractFile source, AbstractFile destination) {
    }

    default public void afterTransfert(AbstractFile source, AbstractFile destination, long dataSizeTranferedFromSource, long dataSizeTranferedToDestination, Duration transfertDuration) {
    }

    public static DataExchangeObserver createLogger() {
        return DataExchangeObserver.createLogger(new DataExchangeObserver(){});
    }

    public static DataExchangeObserver createLogger(final DataExchangeObserver reference) {
        final Logger log = LoggerFactory.getLogger(DataExchangeObserver.class);
        return new DataExchangeObserver(){

            @Override
            public void afterTransfert(AbstractFile source, AbstractFile destination, long dataSizeTranferedFromSource, long dataSizeTranferedToDestination, Duration transfertDuration) {
                log.info("After transfert form \"{}\" to \"{}\": {}/{} bytes during {}", new Object[]{source, destination, dataSizeTranferedFromSource, dataSizeTranferedToDestination, transfertDuration});
                reference.afterTransfert(source, destination, dataSizeTranferedFromSource, dataSizeTranferedToDestination, transfertDuration);
            }

            @Override
            public void beforeTransfert(AbstractFile source, AbstractFile destination) {
                log.debug("Before transfert form \"{}\" to \"{}\"", (Object)source, (Object)destination);
                reference.beforeTransfert(source, destination);
            }

            @Override
            public boolean onTransfertProgressFromSource(AbstractFile source, long startDate, long dataTransferred) {
                if (log.isTraceEnabled()) {
                    log.trace("Transfert form \"{}\": {} bytes, since {}", new Object[]{source, dataTransferred, Duration.ofMillis(System.currentTimeMillis() - startDate)});
                }
                return reference.onTransfertProgressFromSource(source, startDate, dataTransferred);
            }

            @Override
            public boolean onTransfertProgressToDestination(AbstractFile destination, long startDate, long dataTransferred) {
                if (log.isTraceEnabled()) {
                    log.trace("Transfert to \"{}\": {} bytes, since {}", new Object[]{destination, dataTransferred, Duration.ofMillis(System.currentTimeMillis() - startDate)});
                }
                return reference.onTransfertProgressToDestination(destination, startDate, dataTransferred);
            }
        };
    }
}

