/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystem;

public abstract class CommonAbstractFileSystem<T extends AbstractFile>
implements AbstractFileSystem<T> {
    private static final Logger log = LoggerFactory.getLogger(CommonAbstractFileSystem.class);
    private final String basePath;
    private final String standardHostName;
    protected long timeoutDuration;

    protected CommonAbstractFileSystem(String basePath, String standardHostname) {
        this.basePath = AbstractFile.normalizePath(Objects.requireNonNull(basePath, "basePath"));
        this.standardHostName = this.getClass().getSimpleName() + "#" + Objects.requireNonNull(standardHostname, "\"standardHostname\" can't to be null") + basePath;
        log.trace("Init FileSystem, basePath={} standardHostname={} hashCode=#{}", new Object[]{basePath, this.standardHostName, this.hashCode()});
        this.timeoutDuration = 0L;
    }

    public String getPathFromRelative(String path) {
        return AbstractFile.normalizePath(this.basePath + AbstractFile.normalizePath(path));
    }

    public String getBasePath() {
        return this.basePath;
    }

    public final int hashCode() {
        return Objects.hash(this.standardHostName, this.basePath);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonAbstractFileSystem other = (CommonAbstractFileSystem)obj;
        return this.hashCode() == other.hashCode();
    }

    @Override
    public void setTimeout(long duration, TimeUnit unit) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Can't set a timeoutDuration to " + this.timeoutDuration);
        }
        this.timeoutDuration = unit.toMillis(duration);
        if (this.timeoutDuration > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't set a timeoutDuration > Integer.MAX_VALUE: " + this.timeoutDuration);
        }
    }

    @Override
    public long getTimeout() {
        return this.timeoutDuration;
    }
}

