/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystem;
import tv.hd3g.transfertfiles.SizedStoppableCopyCallback;

public abstract class CommonAbstractFile<T extends AbstractFileSystem<?>>
implements AbstractFile {
    protected final T fileSystem;
    protected final String path;

    protected CommonAbstractFile(T fileSystem, String ... path) {
        this.fileSystem = fileSystem;
        this.path = AbstractFile.normalizePath(Stream.of(path).filter(Predicate.not(Objects::isNull)).collect(Collectors.joining("/")));
    }

    @Override
    public Duration getDataExchangeTimeout() {
        return Duration.ofMillis(this.fileSystem.getTimeout());
    }

    @Override
    public AbstractFileSystem<?> getFileSystem() {
        return this.fileSystem;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return FilenameUtils.getName((String)this.path);
    }

    @Override
    public AbstractFile getParent() {
        return this.fileSystem.getFromPath(FilenameUtils.getFullPathNoEndSeparator((String)this.path));
    }

    @Override
    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public int hashCode() {
        return Objects.hash(this.fileSystem, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonAbstractFile other = (CommonAbstractFile)obj;
        return Objects.equals(this.fileSystem, other.fileSystem) && Objects.equals(this.path, other.path);
    }

    public static long observableCopyStream(InputStream inputStream, OutputStream outputStream, int bufferSize, SizedStoppableCopyCallback copyCallback) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(outputStream);
        byte[] buffer = new byte[bufferSize];
        long totalSize = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            if (!((Boolean)copyCallback.apply(totalSize += (long)n)).equals(false)) continue;
            return totalSize;
        }
        return totalSize;
    }
}

