/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.transfertfiles.AbstractFile;

@JsonIgnoreType
public interface AbstractFileSystem<T extends AbstractFile>
extends Closeable {
    public void connect();

    public T getFromPath(String var1);

    default public T getFromPath(String path0, String ... pathN) {
        if (pathN != null && pathN.length > 0) {
            return this.getFromPath(path0 + "/" + Stream.of(pathN).filter(Predicate.not(Objects::isNull)).collect(Collectors.joining("/")));
        }
        return this.getFromPath(path0);
    }

    default public int getIOBufferSize() {
        return 65535;
    }

    default public void setTimeout(long duration, TimeUnit unit) {
    }

    default public long getTimeout() {
        return 30000L;
    }

    public boolean isReusable();

    public boolean isAvaliable();

    public int reusableHashCode();

    public InetAddress getHost();

    public String getUsername();
}

