/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.transfertfiles.AbstractFileSystem;
import tv.hd3g.transfertfiles.CachedFileAttributes;
import tv.hd3g.transfertfiles.DataExchangeInOutStream;
import tv.hd3g.transfertfiles.DataExchangeObserver;
import tv.hd3g.transfertfiles.SizedStoppableCopyCallback;
import tv.hd3g.transfertfiles.TransfertObserver;
import tv.hd3g.transfertfiles.filters.DataExchangeFilter;
import tv.hd3g.transfertfiles.local.LocalFileSystem;

@JsonIgnoreType
public interface AbstractFile {
    public AbstractFileSystem<?> getFileSystem();

    public void copyAbstractToLocal(File var1, TransfertObserver var2);

    public void sendLocalToAbstract(File var1, TransfertObserver var2);

    public String getPath();

    public String getName();

    public AbstractFile getParent();

    public long length();

    public boolean exists();

    public void delete();

    public boolean isDirectory();

    public boolean isFile();

    public boolean isLink();

    public boolean isSpecial();

    public boolean isHidden();

    public long lastModified();

    public Stream<AbstractFile> list();

    public void mkdir();

    public void mkdirs();

    public AbstractFile renameTo(String var1);

    default public AbstractFile renameTo(String path0, String ... pathN) {
        if (pathN != null && pathN.length > 0) {
            return this.renameTo(path0 + "/" + Stream.of(pathN).filter(Predicate.not(Objects::isNull)).collect(Collectors.joining("/")));
        }
        return this.renameTo(path0);
    }

    default public CachedFileAttributes toCache() {
        return new CachedFileAttributes(this);
    }

    default public Stream<CachedFileAttributes> toCachedList() {
        return this.list().map(CachedFileAttributes::new);
    }

    public static String normalizePath(String path) {
        Objects.requireNonNull(path, "path can't be null");
        Object p = path;
        if (((String)p).equals("") || ((String)p).equals("/")) {
            return "/";
        }
        while (((String)p).contains("//")) {
            p = ((String)p).replace("//", "/");
        }
        if (((String)p).contains("../") || ((String)p).contains("./") || ((String)p).contains("/~/") || ((String)p).startsWith("~/") || ((String)p).equals("..") || ((String)p).equals(".") || ((String)p).equals("~")) {
            throw new IllegalArgumentException("Invalid path: \"" + path + "\"");
        }
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        if (((String)p).endsWith("/")) {
            return ((String)p).substring(0, ((String)p).length() - 1);
        }
        return p;
    }

    public long downloadAbstract(OutputStream var1, int var2, SizedStoppableCopyCallback var3);

    public long uploadAbstract(InputStream var1, int var2, SizedStoppableCopyCallback var3);

    public static void checkIsSameFileSystem(AbstractFile from, AbstractFile destination) {
        AbstractFileSystem<?> toFs;
        AbstractFileSystem<?> fromFs = from.getFileSystem();
        if (!fromFs.equals(toFs = destination.getFileSystem()) || fromFs instanceof LocalFileSystem || toFs instanceof LocalFileSystem) {
            return;
        }
        if (fromFs.reusableHashCode() == toFs.reusableHashCode()) {
            throw new UncheckedIOException(new IOException("Can't use same FileSystem instances between to AbstractFiles. Please start a new FS instance for one of the two AbstractFile"));
        }
    }

    default public Duration getDataExchangeTimeout() {
        return Duration.ofSeconds(30L);
    }

    default public DataExchangeInOutStream copyAbstractToAbstract(AbstractFile destination, DataExchangeObserver dataExchangeObserver, DataExchangeFilter ... filters) {
        int bufferSize = Math.max(8192, Math.max(destination.getFileSystem().getIOBufferSize(), this.getFileSystem().getIOBufferSize()));
        DataExchangeInOutStream exchange = new DataExchangeInOutStream(this.getDataExchangeTimeout());
        Stream.of(filters).forEach(exchange::addFilter);
        this.copyAbstractToAbstract(destination, bufferSize, dataExchangeObserver, exchange);
        return exchange;
    }

    default public void copyAbstractToAbstract(AbstractFile destination, int bufferSize, DataExchangeObserver dataExchangeObserver, DataExchangeInOutStream exchange) {
        long readed;
        AbstractFile.checkIsSameFileSystem(this, destination);
        InputStream sourceStream = exchange.getSourceOriginStream();
        OutputStream destStream = exchange.getDestTargetStream();
        long startDate = System.currentTimeMillis();
        SizedStoppableCopyCallback readCallback = copied -> dataExchangeObserver.onTransfertProgressFromSource(this, startDate, (long)copied);
        SizedStoppableCopyCallback writeCallback = copied -> dataExchangeObserver.onTransfertProgressToDestination(destination, startDate, (long)copied);
        dataExchangeObserver.beforeTransfert(this, destination);
        CompletableFuture<Long> downloader = CompletableFuture.supplyAsync(() -> this.downloadAbstract(destStream, bufferSize, readCallback));
        long writed = destination.uploadAbstract(sourceStream, bufferSize, writeCallback);
        try {
            readed = downloader.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        dataExchangeObserver.afterTransfert(this, destination, readed, writed, Duration.ofMillis(System.currentTimeMillis() - startDate));
    }
}

