/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamException;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystem;
import tv.hd3g.transfertfiles.CachedFileAttributes;
import tv.hd3g.transfertfiles.CannotDeleteException;
import tv.hd3g.transfertfiles.CommonAbstractFile;
import tv.hd3g.transfertfiles.SizedStoppableCopyCallback;
import tv.hd3g.transfertfiles.TransfertObserver;
import tv.hd3g.transfertfiles.ftp.FTPFileSystem;
import tv.hd3g.transfertfiles.ftp.FTPListing;
import tv.hd3g.transfertfiles.ftp.StoppableIOStream;
import tv.hd3g.transfertfiles.ftp.StoppableInputStream;
import tv.hd3g.transfertfiles.ftp.StoppableOutputStream;

public class FTPFile
extends CommonAbstractFile<FTPFileSystem> {
    private static final String FTP_ERROR_DURING_LIST = "FTP error during list \"";
    private static final Logger log = LogManager.getLogger();
    private final FTPClient ftpClient;
    private String actualCWD;
    private final String absolutePath;

    FTPFile(FTPFileSystem fileSystem, String relativePath, String absolutePath) {
        super(fileSystem, relativePath);
        this.ftpClient = fileSystem.getClient();
        this.absolutePath = absolutePath;
    }

    @Override
    public AbstractFileSystem<?> getFileSystem() {
        return this.fileSystem;
    }

    private Optional<org.apache.commons.net.ftp.FTPFile> getCurrentFile() {
        try {
            boolean preferList = FTPListing.LIST.equals((Object)((FTPFileSystem)this.fileSystem).getFtpListing());
            if (preferList || !this.ftpClient.hasFeature("MLST")) {
                return Stream.of(this.ftpClient.listFiles(FilenameUtils.getFullPathNoEndSeparator((String)this.absolutePath))).filter(f -> f.getName().equalsIgnoreCase(this.getName())).findFirst();
            }
            return Optional.ofNullable(this.ftpClient.mlistFile(this.absolutePath));
        }
        catch (IOException e) {
            throw new UncheckedIOException(FTP_ERROR_DURING_LIST + this.absolutePath + "\"", e);
        }
    }

    @Override
    public CachedFileAttributes toCache() {
        return this.getCurrentFile().map(f -> this.makeCachedFileAttributesFromFTPFileRaw(this, (org.apache.commons.net.ftp.FTPFile)f)).orElseGet(() -> CachedFileAttributes.notExists(this));
    }

    private CachedFileAttributes makeCachedFileAttributesFromFTPFileRaw(AbstractFile related, org.apache.commons.net.ftp.FTPFile f) {
        return new CachedFileAttributes(related, f.getSize(), f.getTimestamp().getTimeInMillis(), true, f.isDirectory(), f.isFile(), f.isSymbolicLink(), f.isUnknown());
    }

    @Override
    public long length() {
        try {
            if (this.ftpClient.hasFeature("SIZE")) {
                return Optional.ofNullable(this.ftpClient.getSize(this.absolutePath)).map(Long::valueOf).orElse(0L);
            }
            return this.getCurrentFile().map(org.apache.commons.net.ftp.FTPFile::getSize).orElse(0L);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't list \"" + this.absolutePath + "\"", e);
        }
    }

    @Override
    public boolean exists() {
        return this.getCurrentFile().isPresent();
    }

    @Override
    public boolean isDirectory() {
        return this.getCurrentFile().map(org.apache.commons.net.ftp.FTPFile::isDirectory).orElse(false);
    }

    @Override
    public boolean isFile() {
        return this.getCurrentFile().map(org.apache.commons.net.ftp.FTPFile::isFile).orElse(false);
    }

    @Override
    public boolean isLink() {
        return this.getCurrentFile().map(org.apache.commons.net.ftp.FTPFile::isSymbolicLink).orElse(false);
    }

    @Override
    public boolean isSpecial() {
        return this.getCurrentFile().map(org.apache.commons.net.ftp.FTPFile::isUnknown).orElse(false);
    }

    @Override
    public long lastModified() {
        return this.getCurrentFile().map(f -> f.getTimestamp().getTimeInMillis()).orElse(0L);
    }

    @Override
    public Stream<AbstractFile> list() {
        try {
            return Optional.ofNullable(((FTPFileSystem)this.fileSystem).getFtpListing()).orElse(FTPListing.NLST).listDirectory(this.ftpClient, this.absolutePath).filter(name -> !name.equalsIgnoreCase(this.getName())).map(name -> ((FTPFileSystem)this.fileSystem).getFromPath(this.path, (String)name));
        }
        catch (IOException e) {
            throw new UncheckedIOException(FTP_ERROR_DURING_LIST + this.absolutePath + "\"", e);
        }
    }

    @Override
    public Stream<CachedFileAttributes> toCachedList() {
        try {
            return Optional.ofNullable(((FTPFileSystem)this.fileSystem).getFtpListing()).map(ftpL -> {
                if (ftpL.equals((Object)FTPListing.NLST)) {
                    return FTPListing.MLSD;
                }
                return ftpL;
            }).orElseGet(() -> {
                try {
                    if (this.ftpClient.hasFeature("MLSD")) {
                        return FTPListing.MLSD;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error during FTP hasFeature", e);
                }
                return FTPListing.LIST;
            }).rawListDirectory(this.ftpClient, this.absolutePath).peek(f -> log.trace("Raw toCachedList # {}", f)).filter(f -> !f.getName().equalsIgnoreCase(this.getName())).map(f -> this.makeCachedFileAttributesFromFTPFileRaw((AbstractFile)((FTPFileSystem)this.fileSystem).getFromPath(this.path, f.getName()), (org.apache.commons.net.ftp.FTPFile)f));
        }
        catch (IOException e) {
            throw new UncheckedIOException(FTP_ERROR_DURING_LIST + this.absolutePath + "\"", e);
        }
    }

    @Override
    public void delete() {
        boolean directory = this.isDirectory();
        try {
            boolean deleteOk = directory ? this.ftpClient.removeDirectory(this.absolutePath) : this.ftpClient.deleteFile(this.absolutePath);
            if (!deleteOk) {
                throw new CannotDeleteException(this, directory, new IOException("Can't delete " + this.fileSystem + this.path));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't delete \"" + this.absolutePath + "\"", e);
        }
    }

    @Override
    public void mkdir() {
        try {
            boolean mkdirOk = this.ftpClient.makeDirectory(this.absolutePath);
            if (!mkdirOk) {
                throw new IOException("Can't mkdir " + this.fileSystem + this.path);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't mkdir \"" + this.absolutePath + "\"", e);
        }
    }

    @Override
    public void mkdirs() {
        if (this.getPath().equals("/")) {
            return;
        }
        CachedFileAttributes cache = this.toCache();
        if (cache.exists()) {
            if (cache.isDirectory()) {
                return;
            }
            throw new UncheckedIOException(new IOException("Can't mkdirs, this exists, and it's not a directory: " + this.fileSystem + this.path));
        }
        this.getParent().mkdirs();
        this.mkdir();
    }

    @Override
    public AbstractFile renameTo(String path) {
        try {
            String from = this.absolutePath;
            String to = ((FTPFileSystem)this.fileSystem).getPathFromRelative(path);
            boolean renameOk = this.ftpClient.rename(from, to);
            if (!renameOk) {
                throw new IOException("Can't rename form \"" + from + "\" to \"" + to + "\"");
            }
            return ((FTPFileSystem)this.fileSystem).getFromPath(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't rename/move \"" + this.absolutePath + "\"", e);
        }
    }

    @Override
    public void copyAbstractToLocal(File localFile, TransfertObserver observer) {
        this.copy(this.path, localFile.getPath(), localFile, observer, TransfertObserver.TransfertDirection.DISTANTTOLOCAL);
    }

    @Override
    public void sendLocalToAbstract(File localFile, TransfertObserver observer) {
        this.copy(localFile.getPath(), this.path, localFile, observer, TransfertObserver.TransfertDirection.LOCALTODISTANT);
    }

    private void cwdBeforeOperation(String newPath) throws IOException {
        this.actualCWD = this.ftpClient.printWorkingDirectory();
        if (this.absolutePath.equalsIgnoreCase(this.actualCWD)) {
            return;
        }
        log.debug("Do CWD to \"{}\" for {}", (Object)this.actualCWD, (Object)this);
        boolean done = this.ftpClient.changeWorkingDirectory(((FTPFileSystem)this.fileSystem).getPathFromRelative(newPath));
        if (!done) {
            throw new IOException("Can't change working directory to " + this.actualCWD + ": " + this.ftpClient.getReplyString());
        }
    }

    private void restoreCwd() throws IOException {
        if (this.actualCWD == null) {
            return;
        }
        log.debug("Do CWD to \"{}\" for {}", (Object)this.actualCWD, (Object)this);
        boolean done = this.ftpClient.changeWorkingDirectory(this.actualCWD);
        if (!done) {
            throw new IOException("Can't change working directory to " + this.actualCWD + ": " + this.ftpClient.getReplyString());
        }
        this.actualCWD = null;
    }

    private void cwdToParentPath() throws IOException {
        if (this.path.equals("/")) {
            throw new IllegalArgumentException("Can't cwd to ../");
        }
        this.cwdBeforeOperation(FilenameUtils.getFullPathNoEndSeparator((String)this.path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String relativeSource, String relativeDest, File localFile, TransfertObserver observer, TransfertObserver.TransfertDirection transfertDirection) {
        int localBufferSize = Math.max(8192, ((FTPFileSystem)this.fileSystem).getIOBufferSize() * 2);
        AtomicReference<StoppableIOStream> stoppableIOStream = new AtomicReference<StoppableIOStream>();
        AtomicLong sizeToTransfert = new AtomicLong(0L);
        FTPFile thisRef = this;
        long now = System.currentTimeMillis();
        FTPClient fTPClient = this.ftpClient;
        synchronized (fTPClient) {
            boolean done = false;
            try {
                this.ftpClient.setCopyStreamListener((CopyStreamListener)new StoppableListener(relativeSource, relativeDest, localFile, observer, transfertDirection, thisRef, now, stoppableIOStream, sizeToTransfert));
                String absSource = ((FTPFileSystem)this.fileSystem).getPathFromRelative(relativeSource);
                String absDest = ((FTPFileSystem)this.fileSystem).getPathFromRelative(relativeDest);
                Optional<org.apache.commons.net.ftp.FTPFile> oTargetFileRef = this.getCurrentFile();
                observer.beforeTransfert(localFile, this, transfertDirection);
                if (transfertDirection == TransfertObserver.TransfertDirection.DISTANTTOLOCAL) {
                    org.apache.commons.net.ftp.FTPFile sourceFileRef = oTargetFileRef.orElseThrow(() -> new UncheckedIOException(new IOException("Can't access to source file in ftp server")));
                    if (sourceFileRef.isDirectory()) {
                        throw new UncheckedIOException(new IOException("Source file is a directory, can't copy from it"));
                    }
                    sizeToTransfert.set(sourceFileRef.getSize());
                    try (StoppableOutputStream outputstream = new StoppableOutputStream(new BufferedOutputStream(new FileOutputStream(localFile), localBufferSize));){
                        log.info("Download file from FTP \"{}@{}:{}\" to \"{}\" ({} bytes)", (Object)((FTPFileSystem)this.fileSystem).getUsername(), (Object)((FTPFileSystem)this.fileSystem).getHost(), (Object)absSource, (Object)absDest, (Object)sizeToTransfert);
                        stoppableIOStream.set(outputstream);
                        done = this.ftpClient.retrieveFile(this.getName(), (OutputStream)outputstream);
                    }
                }
                if (transfertDirection == TransfertObserver.TransfertDirection.LOCALTODISTANT) {
                    sizeToTransfert.set(localFile.length());
                    String storeName = this.getName();
                    if (oTargetFileRef.isEmpty() || oTargetFileRef.get().isFile()) {
                        this.cwdToParentPath();
                    } else if (oTargetFileRef.get().isDirectory()) {
                        this.cwdBeforeOperation(this.path);
                        storeName = localFile.getName();
                    }
                    try (StoppableInputStream inputstream = new StoppableInputStream(new BufferedInputStream(new FileInputStream(localFile), localBufferSize));){
                        log.info("Upload file \"{}\" ({} bytes) to FTP host \"{}@{}:{}\"", (Object)localFile, (Object)sizeToTransfert, (Object)((FTPFileSystem)this.fileSystem).getUsername(), (Object)((FTPFileSystem)this.fileSystem).getHost(), (Object)absDest);
                        stoppableIOStream.set(inputstream);
                        done = this.ftpClient.storeFile(storeName, (InputStream)inputstream);
                    }
                }
                if (stoppableIOStream.get().isStopped()) {
                    this.actualCWD = null;
                    this.ftpClient.abort();
                    ((FTPFileSystem)this.fileSystem).close();
                    ((FTPFileSystem)this.fileSystem).connect();
                } else {
                    if (!done) {
                        throw new IOException("FTP server refuse the file transfert after the operation: " + this.ftpClient.getReplyString());
                    }
                    observer.afterTransfert(localFile, this, transfertDirection, Duration.of(System.currentTimeMillis() - now, ChronoUnit.MILLIS));
                    this.restoreCwd();
                }
            }
            catch (CopyStreamException e) {
                if (e.getCause() instanceof IOException && e.getCause().getMessage().equals("Manually stop writing")) {
                    try {
                        this.actualCWD = null;
                        this.ftpClient.abort();
                        ((FTPFileSystem)this.fileSystem).close();
                        ((FTPFileSystem)this.fileSystem).connect();
                    }
                    catch (IOException e1) {
                        throw new UncheckedIOException("Can't abort transfert after manual stop", (IOException)((Object)e));
                    }
                    return;
                }
                throw new UncheckedIOException("Can't copy \"" + this.absolutePath + "\"", (IOException)((Object)e));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't copy \"" + this.absolutePath + "\"", e);
            }
            finally {
                this.ftpClient.setCopyStreamListener(null);
            }
        }
    }

    @Override
    public long downloadAbstract(OutputStream outputStream, int bufferSize, SizedStoppableCopyCallback copyCallback) {
        long copied = 0L;
        try (InputStream inputStream = this.ftpClient.retrieveFileStream(this.absolutePath);){
            if (inputStream == null) {
                throw new UncheckedIOException(new IOException("Can't start FTP download [" + this.absolutePath + "]: " + this.ftpClient.getReplyString()));
            }
            AtomicBoolean continueStatus = new AtomicBoolean(false);
            SizedStoppableCopyCallback catchCallBack = size -> {
                Boolean continueCopy = (Boolean)copyCallback.apply(size);
                continueStatus.set(continueCopy);
                return continueCopy;
            };
            copied = FTPFile.observableCopyStream(inputStream, outputStream, bufferSize, catchCallBack);
            if (!continueStatus.get()) {
                this.ftpClient.abort();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't download \"" + this.absolutePath + "\"", e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error("Can't close provided outputStream after use", (Throwable)e);
            }
        }
        this.checkCompletePendingCommand("FTP download error");
        return copied;
    }

    @Override
    public long uploadAbstract(InputStream inputStream, int bufferSize, SizedStoppableCopyCallback copyCallback) {
        long copied = 0L;
        try (OutputStream outputStream = this.ftpClient.storeFileStream(this.absolutePath);){
            if (outputStream == null) {
                throw new UncheckedIOException(new IOException("Can't start FTP upload [" + this.absolutePath + "]: " + this.ftpClient.getReplyString()));
            }
            copied = FTPFile.observableCopyStream(inputStream, outputStream, bufferSize, copyCallback);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't upload \"" + this.absolutePath + "\"", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("Can't close provided inputStream after use", (Throwable)e);
            }
        }
        this.checkCompletePendingCommand("FTP upload error");
        return copied;
    }

    private void checkCompletePendingCommand(String message) {
        try {
            if (!this.ftpClient.completePendingCommand()) {
                throw new UncheckedIOException(new IOException(message + " [" + this.absolutePath + "]: " + this.ftpClient.getReplyString()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Invalid FTP command: \"" + message + "\" on \"" + this.absolutePath + "\"", e);
        }
    }

    private static class StoppableListener
    implements CopyStreamListener {
        final String source;
        final String dest;
        final File localFile;
        final TransfertObserver observer;
        final TransfertObserver.TransfertDirection transfertDirection;
        final FTPFile thisRef;
        final long now;
        final AtomicReference<StoppableIOStream> stoppableIOStream;
        final AtomicLong sizeToTransfert;

        StoppableListener(String source, String dest, File localFile, TransfertObserver observer, TransfertObserver.TransfertDirection transfertDirection, FTPFile thisRef, long now, AtomicReference<StoppableIOStream> stoppableIOStream, AtomicLong sizeToTransfert) {
            this.source = source;
            this.dest = dest;
            this.localFile = localFile;
            this.observer = observer;
            this.transfertDirection = transfertDirection;
            this.thisRef = thisRef;
            this.now = now;
            this.stoppableIOStream = stoppableIOStream;
            this.sizeToTransfert = sizeToTransfert;
        }

        public void bytesTransferred(CopyStreamEvent event) {
        }

        public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
            if (!this.observer.onTransfertProgress(this.localFile, this.thisRef, this.transfertDirection, this.now, totalBytesTransferred)) {
                StoppableIOStream stop = Objects.requireNonNull(this.stoppableIOStream.get(), "Not stoppableStream set before stop transfert");
                log.info("Stop copy FTP file from \"{}\" to \"{}\", ({}/{} bytes)", (Object)this.source, (Object)this.dest, (Object)totalBytesTransferred, (Object)this.sizeToTransfert.get());
                stop.setStop();
            }
        }
    }
}

