/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.filters;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.BufferVault;
import tv.hd3g.transfertfiles.filters.DataExchangeFilter;
import tv.hd3g.transfertfiles.filters.UnaryIOExceptionOperator;

public class DataExchangeFilterOutputStream
implements DataExchangeFilter {
    private static final Logger log = LogManager.getLogger();
    private final int defaultBufferSize;
    private final BufferVault dataDest;
    private final UnaryIOExceptionOperator<OutputStream> streamProvider;
    private OutputStream externalOutputStream;

    public DataExchangeFilterOutputStream(UnaryIOExceptionOperator<OutputStream> streamProvider, int defaultBufferSize) {
        this.defaultBufferSize = defaultBufferSize;
        this.dataDest = new BufferVault(defaultBufferSize);
        this.streamProvider = streamProvider;
        log.debug("Init filter outputstream with buffer={}", (Object)defaultBufferSize);
    }

    public DataExchangeFilterOutputStream(UnaryIOExceptionOperator<OutputStream> streamProvider) {
        this(streamProvider, 32768);
    }

    @Override
    public BufferVault applyDataFilter(boolean last, BufferVault dataSource) throws IOException {
        this.dataDest.clear();
        if (this.externalOutputStream == null) {
            this.externalOutputStream = this.streamProvider.apply(this.dataDest.asOutputStream());
        }
        dataSource.read(this.externalOutputStream);
        this.externalOutputStream.flush();
        if (last) {
            log.debug("Close internal channel, close provided OutputStream");
            this.externalOutputStream.close();
        }
        if (log.isTraceEnabled()) {
            log.trace("Readed before filter {} bytes, after filter {} bytes", (Object)dataSource.getSize(), (Object)this.dataDest.getSize());
        }
        return this.dataDest;
    }

    @Override
    public int ensureMinDataSourcesDataLength() {
        return this.defaultBufferSize;
    }

    @Override
    public void onCancelTransfert() {
        try {
            this.dataDest.clear();
            this.externalOutputStream.close();
        }
        catch (IOException e) {
            log.error("Can't close external stream: {}", (Object)this.getFilterName(), (Object)e);
        }
    }
}

