/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

public class FileAttributesReference {
    protected final String path;
    protected final long length;
    protected final long lastModified;
    protected final boolean exists;
    protected final boolean directory;
    protected final boolean file;
    protected final boolean link;
    protected final boolean special;

    public FileAttributesReference(String path, long length, long lastModified, boolean exists, boolean directory, boolean file, boolean link, boolean special) {
        this.path = path;
        this.length = length;
        this.lastModified = lastModified;
        this.exists = exists;
        this.directory = directory;
        this.file = file;
        this.link = link;
        this.special = special;
    }

    public FileAttributesReference(String path, long length, long lastModified, boolean exists, boolean directory) {
        this.path = path;
        this.length = length;
        this.lastModified = lastModified;
        this.directory = directory;
        this.exists = exists;
        this.file = !directory;
        this.link = false;
        this.special = false;
    }

    public String getName() {
        return FilenameUtils.getName((String)this.path);
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getPath();
    }

    public String getParentPath() {
        return FilenameUtils.getFullPathNoEndSeparator((String)this.path);
    }

    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public long length() {
        return this.length;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isLink() {
        return this.link;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.file, this.lastModified, this.length, this.link, this.path, this.special);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileAttributesReference other = (FileAttributesReference)obj;
        return this.directory == other.directory && this.file == other.file && this.lastModified == other.lastModified && this.length == other.length && this.link == other.link && Objects.equals(this.path, other.path) && this.special == other.special;
    }
}

